/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalCustomer;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalCustomerStaff;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalCustomerRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalCustomerService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalCustomerStaffService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="terminalCustomerService")
public class TerminalCustomerServiceImpl
implements TerminalCustomerService {
    @Autowired
    private TerminalCustomerRepository terminalCustomerRepository;
    @Autowired
    private TerminalCustomerStaffService terminalCustomerStaffService;

    @Override
    public TerminalCustomer findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (TerminalCustomer)((Object)this.terminalCustomerRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public TerminalCustomer create(TerminalCustomer terminalCustomer) {
        this.createValidate(terminalCustomer);
        this.terminalCustomerRepository.saveOrUpdate((Object)terminalCustomer);
        return terminalCustomer;
    }

    @Override
    @Transactional
    public TerminalCustomer update(TerminalCustomer terminalCustomer) {
        this.updateValidate(terminalCustomer);
        this.terminalCustomerRepository.saveOrUpdate((Object)terminalCustomer);
        return terminalCustomer;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalCustomer> terminalCustomers = this.terminalCustomerRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCustomers) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalCustomers.stream().forEach(terminalCustomer -> terminalCustomer.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.terminalCustomerRepository.saveOrUpdateBatch(terminalCustomers);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalCustomer> terminalCustomers = this.terminalCustomerRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCustomers) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u542f\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalCustomers.stream().forEach(terminalCustomer -> terminalCustomer.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.terminalCustomerRepository.saveOrUpdateBatch(terminalCustomers);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalCustomer> terminalCustomers = this.terminalCustomerRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCustomers) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u7981\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalCustomers.stream().forEach(terminalCustomer -> terminalCustomer.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.terminalCustomerRepository.saveOrUpdateBatch(terminalCustomers);
    }

    @Override
    @Transactional
    public void deleteByTerminalCodes(List<String> terminalCodeList) {
        LambdaQueryWrapper terminalCustomerLambdaQueryChainWrapper = Wrappers.lambdaQuery();
        terminalCustomerLambdaQueryChainWrapper.in(TerminalCustomer::getTerminalCode, terminalCodeList);
        this.terminalCustomerStaffService.deleteByTerminalCodes(terminalCodeList);
        this.terminalCustomerRepository.remove((Wrapper)terminalCustomerLambdaQueryChainWrapper);
    }

    @Override
    @Transactional
    public void saveBatch(List<TerminalCustomer> customers) {
        if (CollectionUtils.isEmpty(customers)) {
            return;
        }
        Map<String, List<TerminalCustomer>> map = customers.stream().collect(Collectors.groupingBy(TerminalCustomer::getTerminalCode));
        for (Map.Entry<String, List<TerminalCustomer>> entry : map.entrySet()) {
            List<TerminalCustomer> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            List distinct = value.stream().map(TerminalCustomer::getCustomerCode).distinct().collect(Collectors.toList());
            Validate.isTrue((distinct.size() == value.size() ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u91cd\u590d", (Object[])new Object[0]);
        }
        List<TerminalCustomerStaff> collect = customers.stream().map(s -> s.getStaff() == null ? new ArrayList() : s.getStaff()).flatMap(Collection::stream).collect(Collectors.toList());
        this.terminalCustomerStaffService.saveBatch(collect);
        this.terminalCustomerRepository.saveBatch(customers);
    }

    @Override
    public List<TerminalCustomer> findByTerminalCodes(List<String> terminalCodeList) {
        List list = ((LambdaQueryChainWrapper)this.terminalCustomerRepository.lambdaQuery().in(TerminalCustomer::getTerminalCode, terminalCodeList)).list();
        List<TerminalCustomerStaff> staff = this.terminalCustomerStaffService.findByTerminalCodes(terminalCodeList);
        if (CollectionUtils.isEmpty(staff)) {
            return list;
        }
        list.forEach(s -> s.setStaff(staff.stream().filter(m -> StringUtils.equals((CharSequence)m.getTerminalCode(), (CharSequence)s.getTerminalCode()) && StringUtils.equals((CharSequence)m.getCustomerCode(), (CharSequence)s.getCustomerCode())).collect(Collectors.toList())));
        return list;
    }

    @Override
    public TerminalCustomer findValidByTerminalCodeAndCustomerCode(String terminalCode, String customerCode) {
        return (TerminalCustomer)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.terminalCustomerRepository.lambdaQuery().eq(TerminalCustomer::getTerminalCode, (Object)terminalCode)).eq(TerminalCustomer::getCustomerCode, (Object)customerCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
    }

    private void createValidate(TerminalCustomer terminalCustomer) {
        Validate.notNull((Object)((Object)terminalCustomer), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        terminalCustomer.setId(null);
        Validate.notBlank((CharSequence)terminalCustomer.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(TerminalCustomer terminalCustomer) {
        Validate.notNull((Object)((Object)terminalCustomer), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalCustomer.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalCustomer.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

