/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalCustomerStaff;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalCustomerStaffRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalCustomerStaffService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="terminalCustomerStaffService")
public class TerminalCustomerStaffServiceImpl
implements TerminalCustomerStaffService {
    @Autowired
    private TerminalCustomerStaffRepository terminalCustomerStaffRepository;

    @Override
    public TerminalCustomerStaff findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (TerminalCustomerStaff)((Object)this.terminalCustomerStaffRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public TerminalCustomerStaff create(TerminalCustomerStaff terminalCustomerStaff) {
        this.createValidate(terminalCustomerStaff);
        this.terminalCustomerStaffRepository.saveOrUpdate((Object)terminalCustomerStaff);
        return terminalCustomerStaff;
    }

    @Override
    @Transactional
    public TerminalCustomerStaff update(TerminalCustomerStaff terminalCustomerStaff) {
        this.updateValidate(terminalCustomerStaff);
        this.terminalCustomerStaffRepository.saveOrUpdate((Object)terminalCustomerStaff);
        return terminalCustomerStaff;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalCustomerStaff> terminalCustomerStaffs = this.terminalCustomerStaffRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCustomerStaffs) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalCustomerStaffs.stream().forEach(terminalCustomerStaff -> terminalCustomerStaff.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.terminalCustomerStaffRepository.saveOrUpdateBatch(terminalCustomerStaffs);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalCustomerStaff> terminalCustomerStaffs = this.terminalCustomerStaffRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCustomerStaffs) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u542f\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalCustomerStaffs.stream().forEach(terminalCustomerStaff -> terminalCustomerStaff.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.terminalCustomerStaffRepository.saveOrUpdateBatch(terminalCustomerStaffs);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalCustomerStaff> terminalCustomerStaffs = this.terminalCustomerStaffRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCustomerStaffs) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u7981\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalCustomerStaffs.stream().forEach(terminalCustomerStaff -> terminalCustomerStaff.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.terminalCustomerStaffRepository.saveOrUpdateBatch(terminalCustomerStaffs);
    }

    @Override
    public List<TerminalCustomerStaff> findByTerminalCodes(List<String> terminalCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.terminalCustomerStaffRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(TerminalCustomerStaff::getTerminalCode, terminalCodeList)).list();
    }

    @Override
    public void deleteByTerminalCodes(List<String> terminalCodeList) {
        LambdaQueryWrapper lq = Wrappers.lambdaQuery();
        this.terminalCustomerStaffRepository.remove((Wrapper)((LambdaQueryWrapper)lq.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(TerminalCustomerStaff::getTerminalCode, terminalCodeList));
    }

    @Override
    public void saveBatch(List<TerminalCustomerStaff> staff) {
        this.terminalCustomerStaffRepository.saveBatch(staff);
    }

    private void createValidate(TerminalCustomerStaff terminalCustomerStaff) {
        Validate.notNull((Object)((Object)terminalCustomerStaff), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        terminalCustomerStaff.setId(null);
    }

    private void updateValidate(TerminalCustomerStaff terminalCustomerStaff) {
        Validate.notNull((Object)((Object)terminalCustomerStaff), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalCustomerStaff.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

