/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.promoters.sdk.service.TerminalPromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalCustomer;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaCustomerOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSignAccount;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalTag;
import com.biz.crm.mdm.business.terminal.local.helper.TerminalHelper;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalCustomerService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaCustomerOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSignAccountService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalTagService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCusSelectDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalEventDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRegionSelectDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSellingPartyDto;
import com.biz.crm.mdm.business.terminal.sdk.enums.TerminalTypeEnum;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalEventListener;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.strategy.CompletedCountStrategy;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalEmployeeVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSellingPartyVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgDimChlDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgDimChlVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalService")
public class TerminalServiceImpl
implements TerminalService {
    private static final Logger log = LoggerFactory.getLogger(TerminalServiceImpl.class);
    private static volatile Cache<String, List<Terminal>> cache = null;
    @Autowired(required=false)
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TerminalRelaCustomerOrgService terminalRelaCustomerOrgService;
    @Autowired(required=false)
    private TerminalRelaOrgService terminalRelaOrgService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TerminalContactService terminalContactService;
    @Autowired(required=false)
    private TerminalSupplyVoService terminalSupplyVoService;
    @Autowired(required=false)
    private TerminalSupplyService terminalSupplyService;
    @Autowired(required=false)
    private TerminalSignAccountService terminalSignAccountService;
    @Autowired(required=false)
    private TerminalTagService terminalTagService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private List<CompletedCountStrategy> completedCountStrategies;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private TerminalCustomerService terminalCustomerService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private TerminalPromotersVoService terminalPromotersVoService;
    @Value(value="${mdg.app-code:}")
    private String APP_CODE;
    @Resource
    private TerminalHelper terminalHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalServiceImpl() {
        if (cache != null) return;
        Class<TerminalServiceImpl> clazz = TerminalServiceImpl.class;
        synchronized (TerminalServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void transformationTerminalData(String tenantCode, MasterDataMdgDimChlVo masterDataMdgDimChlVo, Terminal terminal) {
        terminal.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        terminal.setTerminalTypeCode(TerminalTypeEnum.TERMINAL.getDictCode());
        terminal.setTerminalCode(masterDataMdgDimChlVo.getStoreCode());
        terminal.setTerminalName(masterDataMdgDimChlVo.getStoreName());
        terminal.setTerminalTypeCode(masterDataMdgDimChlVo.getAcStoreType());
        terminal.setTerminalTypeName(masterDataMdgDimChlVo.getAcStoreTypeDesc());
        terminal.setSettleDestination(masterDataMdgDimChlVo.getServedType());
        terminal.setSellerCode(masterDataMdgDimChlVo.getSellerCode());
        terminal.setSellerName(masterDataMdgDimChlVo.getSellerName());
        terminal.setRegionCode(masterDataMdgDimChlVo.getSalesRegionCode());
        terminal.setRegionName(masterDataMdgDimChlVo.getSalesRegionName());
        terminal.setProvinceName(masterDataMdgDimChlVo.getProvinceName());
        terminal.setProvinceCode(masterDataMdgDimChlVo.getProvinceCode());
        terminal.setCityName(masterDataMdgDimChlVo.getCityName());
        terminal.setCityCode(masterDataMdgDimChlVo.getCityCode());
        terminal.setDistrictName(masterDataMdgDimChlVo.getDistrictName());
        terminal.setDistrictCode(masterDataMdgDimChlVo.getDistrictCode());
        terminal.setCustomerRetailerRegion(masterDataMdgDimChlVo.getRetailerRegion());
        terminal.setCustomerRetailerCode(masterDataMdgDimChlVo.getRetailerCode());
        terminal.setCustomerRetailerName(masterDataMdgDimChlVo.getRetailerName());
        terminal.setCustomerRetailerInternalTerminalCode(masterDataMdgDimChlVo.getRetailerStoreCode());
        terminal.setCustomerRetailerInternalTerminalType(masterDataMdgDimChlVo.getRetailerStoreType());
        terminal.setTerminalArea(masterDataMdgDimChlVo.getStoreAcreage());
        terminal.setTerminalRegionName(masterDataMdgDimChlVo.getStoreArea());
        terminal.setCloseShopTime(null);
        terminal.setStartShopTime(null);
        terminal.setVerticalTime(null);
        try {
            terminal.setCloseShopTime(masterDataMdgDimChlVo.getStoreCloseTime());
            terminal.setStartShopTime(masterDataMdgDimChlVo.getStoreOpenTime());
            terminal.setVerticalTime(DateUtil.getTimestamp((String)masterDataMdgDimChlVo.getStoreVerticalTime()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        terminal.setTerminalState(masterDataMdgDimChlVo.getStoreStatus());
        terminal.setPointsWarehouseCode(masterDataMdgDimChlVo.getSubWarehouseCode());
        terminal.setPointsWarehouseName(masterDataMdgDimChlVo.getSubWarehouseName());
        terminal.setBusinessProvinceName(masterDataMdgDimChlVo.getAchievementProvinceName());
        terminal.setBusinessProvinceCode(masterDataMdgDimChlVo.getAchievementProvinceCode());
        terminal.setBusinessCityName(masterDataMdgDimChlVo.getAchievementCityName());
        terminal.setBusinessCityCode(masterDataMdgDimChlVo.getAchievementCityCode());
        terminal.setBusinessDistrictName(masterDataMdgDimChlVo.getAchievementDistrictName());
        terminal.setBusinessDistrictCode(masterDataMdgDimChlVo.getAchievementDistrictCode());
        terminal.setSettlePatrolTerminal(masterDataMdgDimChlVo.getInspectionStoreMark());
        terminal.setPatrolTerminalStandardName(masterDataMdgDimChlVo.getInspectionStandardName());
        terminal.setSettleDestination(masterDataMdgDimChlVo.getServedType());
        terminal.setWarehouseName(masterDataMdgDimChlVo.getDcWarehouseName());
        terminal.setDistrictLevelCode(masterDataMdgDimChlVo.getAcCityType());
        terminal.setDistrictLevelName(masterDataMdgDimChlVo.getAcCityTypeDesc());
        terminal.setWarehouseCode(masterDataMdgDimChlVo.getDcWarehouseCode());
        terminal.setTerminalLevel(masterDataMdgDimChlVo.getStoreLevel());
        if (StringUtils.isNotBlank((CharSequence)masterDataMdgDimChlVo.getStoreLongitude()) || StringUtils.isNotBlank((CharSequence)masterDataMdgDimChlVo.getStoreLatitude())) {
            try {
                String storeLatitude;
                String storeLongitude;
                if (StringUtils.isNotBlank((CharSequence)masterDataMdgDimChlVo.getStoreLongitude()) && StringUtils.isNotBlank((CharSequence)(storeLongitude = masterDataMdgDimChlVo.getStoreLongitude().replaceAll(" ", "")))) {
                    terminal.setLongitude(new BigDecimal(storeLongitude));
                }
                if ((StringUtils.isNotBlank((CharSequence)masterDataMdgDimChlVo.getStoreLongitude()) || StringUtils.isNotBlank((CharSequence)masterDataMdgDimChlVo.getStoreLatitude())) && StringUtils.isNotBlank((CharSequence)(storeLatitude = masterDataMdgDimChlVo.getStoreLatitude()))) {
                    terminal.setLatitude(new BigDecimal(storeLatitude));
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        terminal.setTenantCode(tenantCode);
        terminal.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    }

    @Override
    public Page<Terminal> findByConditions(Pageable pageable, TerminalPaginationDto dto) {
        String cacheKey;
        List records;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Terminal> byConditions = new Page<Terminal>();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)dto.getTenantCode())) {
            sb.append(dto.getTenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDelFlag())) {
            sb.append(dto.getDelFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEnableStatus())) {
            sb.append(dto.getEnableStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProcessStatus())) {
            sb.append(dto.getProcessStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
            sb.append(dto.getOrgCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerOrgCode())) {
            sb.append(dto.getCustomerOrgCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalType())) {
            sb.append(dto.getTerminalType());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalCode())) {
            sb.append(dto.getTerminalCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalName())) {
            sb.append(dto.getTerminalName());
        }
        if ((records = (List)cache.getIfPresent((Object)(cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), sb.toString()})))) == null) {
            byConditions = this.terminalRepository.findByConditions((Page<Terminal>)page, dto);
            if (CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
                return byConditions;
            }
            records = byConditions.getRecords();
            cache.put((Object)cacheKey, (Object)records);
        }
        List orgCodes = records.stream().map(Terminal::getOrgCode).collect(Collectors.toList());
        List orgVos = this.orgVoService.findByOrgCodes(orgCodes);
        List<String> terminalCodes = records.stream().map(Terminal::getTerminalCode).collect(Collectors.toList());
        List<TerminalRelaCustomerOrg> customerOrgList = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodes);
        List<TerminalRelaOrg> orgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodes);
        List<TerminalTag> terminalTagList = this.terminalTagService.findByTerminalCodes(Sets.newHashSet(terminalCodes));
        List<TerminalSupply> terminalSupplies = this.terminalSupplyService.findByTerminalCodes(terminalCodes);
        Map<Object, Object> customerOrgMap = Maps.newHashMap();
        Map<Object, Object> orgMap = Maps.newHashMap();
        Map<Object, Object> tagMap = Maps.newHashMap();
        Map<Object, Object> supplyMap = Maps.newHashMap();
        Map orgVoMap = Optional.ofNullable(orgVos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        if (CollectionUtils.isNotEmpty(customerOrgList)) {
            customerOrgMap = customerOrgList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getTerminalCode())).collect(Collectors.toMap(TerminalRelaCustomerOrg::getTerminalCode, v -> v, (a, b) -> a));
        }
        if (CollectionUtils.isNotEmpty(orgList)) {
            orgMap = orgList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getTerminalCode())).collect(Collectors.toMap(TerminalRelaOrg::getTerminalCode, v -> v, (a, b) -> a));
        }
        if (CollectionUtils.isNotEmpty(terminalTagList)) {
            tagMap = terminalTagList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).collect(Collectors.groupingBy(TerminalTag::getTerminalCode));
        }
        if (CollectionUtils.isNotEmpty(terminalSupplies)) {
            supplyMap = terminalSupplies.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).collect(Collectors.groupingBy(TerminalSupply::getTerminalCode));
        }
        List<TerminalContact> terminalContacts = this.terminalContactService.findByTerminalCodes(terminalCodes);
        Map<Object, Object> listMap = new HashMap();
        if (!CollectionUtils.isEmpty(terminalContacts)) {
            listMap = terminalContacts.stream().collect(Collectors.groupingBy(TerminalContact::getTerminalCode));
        }
        for (Terminal terminal : records) {
            OrgVo orgVo = (OrgVo)orgVoMap.get(terminal.getOrgCode());
            if (orgVo != null) {
                terminal.setOrgName(orgVo.getOrgName());
            }
            if (customerOrgMap.containsKey(terminal.getTerminalCode())) {
                terminal.setCustomerOrg((TerminalRelaCustomerOrg)((Object)customerOrgMap.get(terminal.getTerminalCode())));
            }
            if (orgMap.containsKey(terminal.getTerminalCode())) {
                terminal.setOrg((TerminalRelaOrg)((Object)orgMap.get(terminal.getTerminalCode())));
            }
            if (supplyMap.containsKey(terminal.getTerminalCode())) {
                terminal.setSupplyList((List)supplyMap.get(terminal.getTerminalCode()));
            }
            terminal.setTagList((List)tagMap.get(terminal.getTerminalCode()));
            if (CollectionUtils.isNotEmpty(terminal.getTagList())) {
                terminal.setTagStr(terminal.getTagList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTagDescription())).map(TerminalTag::getTagDescription).collect(Collectors.joining(",")));
            }
            terminal.setContactList((List)listMap.get(terminal.getTerminalCode()));
        }
        return byConditions;
    }

    @Override
    public Terminal findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.terminalRepository.findById(id);
    }

    @Override
    @Transactional
    public Terminal create(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminal.getTerminalName()), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)terminal.getTerminalCode())) {
            terminal.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(terminal.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(terminal.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        terminal.setTenantCode(TenantUtils.getTenantCode());
        terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        terminal.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.terminalRepository.saveOrUpdate((Object)terminal);
        TerminalVo vo = (TerminalVo)this.nebulaToolkitService.copyObjectByBlankList((Object)terminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        TerminalEventDto eventDto = new TerminalEventDto();
        eventDto.setOriginal(null);
        eventDto.setNewest(vo);
        return terminal;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Terminal update(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminal.getId()), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String currentId = terminal.getId();
        Terminal current = this.terminalRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)terminal.getTerminalCode().equals(current.getTerminalCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        terminal.setTenantCode(TenantUtils.getTenantCode());
        this.terminalRepository.updateByIdAndTenantCode(terminal, terminal.getTenantCode());
        TerminalVo vo1 = (TerminalVo)this.nebulaToolkitService.copyObjectByBlankList((Object)current, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        TerminalVo vo2 = (TerminalVo)this.nebulaToolkitService.copyObjectByBlankList((Object)terminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<TerminalRelaOrgVo>> map = this.findTerminalOrgMap(Lists.newArrayList((Object[])new Terminal[]{current}));
        vo2.setOrgList(map.get(terminal.getTerminalCode()));
        TerminalEventDto eventDto = new TerminalEventDto();
        eventDto.setOriginal(vo1);
        eventDto.setNewest(vo2);
        return terminal;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        List<Terminal> list = this.terminalRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<TerminalRelaOrgVo>> map = this.findTerminalOrgMap(list);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo vo : voList) {
            TerminalEventDto eventDto = new TerminalEventDto();
            vo.setOrgList(map.get(vo.getTerminalCode()));
            eventDto.setNewest(vo);
            eventDto.setOriginal(vo);
            SerializableBiConsumer & Serializable onEnable = TerminalEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        List<Terminal> list = this.terminalRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo vo : voList) {
            TerminalEventDto eventDto = new TerminalEventDto();
            eventDto.setNewest(vo);
            eventDto.setOriginal(vo);
            SerializableBiConsumer & Serializable onDisable = TerminalEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        List<TerminalRelaOrg> terminalOrgList;
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Terminal> terminalList = this.terminalRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(terminalList)) {
            return;
        }
        this.terminalRepository.updateDelFlagByIds(ids);
        List<String> terminalCodes = terminalList.stream().filter(terminal -> StringUtils.isNotBlank((CharSequence)terminal.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(terminalCodes) && CollectionUtils.isNotEmpty(terminalOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodes))) {
            map = terminalOrgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()})).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toSet())));
        }
        this.deleteExtInfo(terminalCodes);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo vo : voList) {
            Set curSet = (Set)map.get(vo.getTerminalCode());
            if (CollectionUtils.isNotEmpty((Collection)curSet)) {
                LinkedList curOrgList = Lists.newLinkedList();
                for (String orgCode : curSet) {
                    TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
                    cur.setOrgCode(orgCode);
                    curOrgList.add(cur);
                }
                vo.setOrgList((List)curOrgList);
            }
            TerminalEventDto eventDto = new TerminalEventDto();
            eventDto.setOriginal(vo);
            SerializableBiConsumer & Serializable onDelete = TerminalEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    public List<Terminal> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(terminalCodes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), ids, terminalCodes});
        List<Terminal> records = (List<Terminal>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRepository.findDetailsByIdsOrTerminalCodes(ids, terminalCodes);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public List<Terminal> findByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return new ArrayList<Terminal>(0);
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), terminalCodes});
        List<Terminal> records = (List<Terminal>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRepository.findByCodes(terminalCodes);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public List<Terminal> findByCustomerOrgCodes(List<String> customerOrgCodes) {
        if (CollectionUtils.isEmpty(customerOrgCodes)) {
            return new ArrayList<Terminal>(0);
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), customerOrgCodes});
        List<Terminal> records = (List<Terminal>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRepository.findByCustomerOrgCodes(customerOrgCodes, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode());
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        if (CollectionUtils.isEmpty((Collection)(dto = Optional.ofNullable(dto).orElse(new TerminalCodeSearchDto())).getOrgCodeSet()) && CollectionUtils.isEmpty((Collection)dto.getChannelSet()) && CollectionUtils.isEmpty((Collection)dto.getTagSet())) {
            return Sets.newHashSet();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.terminalRepository.findByTerminalCodeSearchDto(dto);
    }

    @Override
    public Terminal findByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        List<Terminal> list = this.terminalRepository.findByCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Terminal findByProcessNumber(String processNumber) {
        if (StringUtils.isBlank((CharSequence)processNumber)) {
            return null;
        }
        return this.terminalRepository.findByProcessNumber(processNumber);
    }

    @Override
    @Transactional
    public void updateByProcess(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getId(), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getProcessStatus(), (String)"\u7ec8\u7aef\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRepository.updateByIdAndTenantCode(terminal, TenantUtils.getTenantCode());
    }

    @Override
    public Map<String, Integer> findCountByCreateAccountAndDateTypeAndFromType(String createAccount, String dateType, String fromType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fromType, dateType})) {
            return new HashMap<String, Integer>(0);
        }
        if (StringUtils.isBlank((CharSequence)createAccount)) {
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            createAccount = loginDetails.getAccount();
        }
        if (CollectionUtils.isEmpty(this.completedCountStrategies)) {
            return new HashMap<String, Integer>(0);
        }
        for (CompletedCountStrategy completedCountStrategy : this.completedCountStrategies) {
            if (!completedCountStrategy.dateType().equals(dateType)) continue;
            return completedCountStrategy.findCountByCreateAccountAndFromType(createAccount, fromType);
        }
        return null;
    }

    @Override
    public List<CommonSelectVo> findCusStoreFormSelectList(TerminalCusSelectDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TerminalCusSelectDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237", (Object[])new Object[0]);
        return this.terminalRepository.findCusStoreFormSelectList(dto);
    }

    @Override
    public List<CommonSelectVo> findStoreFormSelectList(TerminalCusSelectDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TerminalCusSelectDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.terminalRepository.findStoreFormSelectList(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullDimChlList(MasterDataMdgDimChlDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgDimChlDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getDs())) {
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            Date nowTime = now.getTime();
            dto.setDs(DateUtil.date_yyyyMMdd.format(nowTime));
        }
        if (StringUtils.isEmpty((CharSequence)dto.getAppCode())) {
            dto.setAppCode(this.APP_CODE);
        }
        if (Objects.isNull(dto.getAddDay())) {
            dto.setAddDay(Integer.valueOf(1));
        }
        int addDay = dto.getAddDay();
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        boolean lock = true;
        int loopMax = 4000;
        int pageNumStart = Integer.parseInt(dto.getPageNum());
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            Date startDate = DateUtil.parseDate((String)dto.getDs(), (String)"yyyyMMdd");
            block4: for (int i = 0; i < addDay; ++i) {
                dto.setDs(DateUtil.date_yyyyMMdd.format(DateUtil.dateAddDay((Date)startDate, (Integer)i)));
                for (int pageNum = pageNumStart; loopMax > pageNum; ++pageNum) {
                    dto.setPageNum(String.valueOf(pageNum));
                    List mdgList = this.masterDataMdgService.pullDimChlList(dto);
                    if (CollectionUtils.isEmpty((Collection)mdgList)) continue block4;
                    List<Terminal> pullList = this.dimChlValidate(mdgList);
                    List<String> terminalCodeList = pullList.stream().map(Terminal::getTerminalCode).collect(Collectors.toList());
                    this.terminalHelper.buildData(pullList);
                    List<Terminal> byDestinationCodes = this.terminalRepository.findByTerminalCodeLists(terminalCodeList);
                    if (CollectionUtils.isEmpty(byDestinationCodes)) {
                        this.saveOrUpdate(pullList, null);
                        continue block4;
                    }
                    ArrayList<Terminal> saveList = new ArrayList<Terminal>();
                    ArrayList<Terminal> updateList = new ArrayList<Terminal>();
                    Map<String, Terminal> map = byDestinationCodes.stream().collect(Collectors.toMap(Terminal::getTerminalCode, v -> v, (oldValue, newValue) -> newValue));
                    pullList.forEach(pull -> {
                        Terminal oldEntity = (Terminal)((Object)((Object)map.get(pull.getTerminalCode())));
                        if (Objects.nonNull((Object)oldEntity)) {
                            pull.setId(oldEntity.getId());
                            pull.setCreateAccount(oldEntity.getCreateAccount());
                            pull.setCreateName(oldEntity.getCreateName());
                            pull.setCreateTime(oldEntity.getCreateTime());
                            updateList.add((Terminal)((Object)pull));
                        } else {
                            saveList.add((Terminal)((Object)pull));
                        }
                    });
                    this.saveOrUpdate(saveList, updateList);
                }
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdate(List<Terminal> saveList, List<Terminal> updateList) {
        if (!CollectionUtils.isEmpty(saveList)) {
            this.terminalRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.terminalRepository.updateBatchById(updateList);
        }
    }

    @Override
    public List<CommonSelectVo> findRegionFormSelectList(TerminalRegionSelectDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TerminalRegionSelectDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.terminalRepository.findRegionFormSelectList(dto);
    }

    @Override
    public Page<TerminalSellingPartyVo> findSellingPartyByConditions(Pageable pageable, TerminalSellingPartyDto partyDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(partyDto)) {
            partyDto = new TerminalSellingPartyDto();
        }
        partyDto.setTenantCode(TenantUtils.getTenantCode());
        return this.terminalRepository.findSellingPartyByConditions(pageable, partyDto);
    }

    @Override
    public Page<TerminalEmployeeVo> findByConditionsForEmployee(Pageable pageable, TerminalPaginationDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List<Terminal> byConditions = this.terminalRepository.findListByConditions(dto);
        if (CollectionUtils.isNotEmpty(byConditions)) {
            Map terminalMap = byConditions.stream().collect(Collectors.toMap(Terminal::getTerminalCode, Function.identity()));
            List terminalCodeList = byConditions.stream().map(Terminal::getTerminalCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(terminalCodeList)) {
                Page promotersVoList = this.terminalPromotersVoService.findPromotersByTerminalCodes(pageable, terminalCodeList);
                page.setTotal(promotersVoList.getTotal());
                List records = promotersVoList.getRecords();
                if (CollectionUtils.isNotEmpty((Collection)records)) {
                    ArrayList<TerminalEmployeeVo> terminalEmployeeVoList = new ArrayList<TerminalEmployeeVo>();
                    for (PromotersVo record : records) {
                        Terminal terminal = (Terminal)((Object)terminalMap.get(record.getTerminalCode()));
                        TerminalEmployeeVo terminalEmployeeVo = (TerminalEmployeeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)record, TerminalEmployeeVo.class, null, null, new String[0]);
                        terminalEmployeeVo.setTerminalName(terminal.getTerminalName());
                        terminalEmployeeVoList.add(terminalEmployeeVo);
                    }
                    page.setRecords(terminalEmployeeVoList);
                }
            }
        }
        return page;
    }

    @Override
    public List<SalesOrgVo> findOrgListByCodeList(List<String> codeList) {
        return null;
    }

    @Override
    public Page<Terminal> findTerminalByConditions(Pageable pageable, TerminalPaginationDto paginationDto) {
        List<TerminalSignAccount> accounts;
        List<TerminalCustomer> customers;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        paginationDto = Optional.ofNullable(paginationDto).orElse(new TerminalPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Terminal> byConditions = new Page<Terminal>();
        byConditions = this.terminalRepository.findTerminalByConditions((Page<Terminal>)page, paginationDto);
        if (CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
            return byConditions;
        }
        List records = byConditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return byConditions;
        }
        List<String> terminalCodes = records.stream().map(Terminal::getTerminalCode).collect(Collectors.toList());
        List<TerminalContact> terminalContacts = this.terminalContactService.findByTerminalCodes(terminalCodes);
        Map<Object, Object> listMap = new HashMap();
        Map<Object, Object> customersMap = new HashMap();
        Map<Object, Object> accountsMap = new HashMap();
        if (!CollectionUtils.isEmpty(terminalContacts)) {
            listMap = terminalContacts.stream().collect(Collectors.groupingBy(TerminalContact::getTerminalCode));
        }
        if (!CollectionUtils.isEmpty(customers = this.terminalCustomerService.findByTerminalCodes(terminalCodes))) {
            customersMap = customers.stream().collect(Collectors.groupingBy(TerminalCustomer::getTerminalCode));
        }
        if (!CollectionUtils.isEmpty(accounts = this.terminalSignAccountService.findByTerminalCodes(terminalCodes))) {
            accountsMap = accounts.stream().collect(Collectors.groupingBy(TerminalSignAccount::getTerminalCode));
        }
        for (Terminal terminal : records) {
            terminal.setContactList((List)listMap.get(terminal.getTerminalCode()));
            terminal.setCustomerList((List)customersMap.get(terminal.getTerminalCode()));
            terminal.setTerminalSignAccountList((List)accountsMap.get(terminal.getTerminalCode()));
        }
        return byConditions;
    }

    private void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u5782\u76f4\u95e8\u5e97\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.redisMutexService.unlock("companyArea_lock:lock:" + yearMonthDay);
    }

    private List<Terminal> dimChlValidate(List<MasterDataMdgDimChlVo> masterDataMdgDimChlVos) {
        HashMap codeMap = new HashMap(8);
        ArrayList<Terminal> pullList = new ArrayList<Terminal>();
        String tenantCode = TenantUtils.getTenantCode();
        masterDataMdgDimChlVos.forEach(masterDataMdgDimChlVo -> {
            if (StringUtils.isEmpty((CharSequence)masterDataMdgDimChlVo.getStoreCode())) {
                log.info("\u672c\u6b21\u62c9\u53d6\u6570\u636e\uff1a" + masterDataMdgDimChlVos);
                throw new RuntimeException("\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            Terminal terminal = new Terminal();
            if (codeMap.containsKey(masterDataMdgDimChlVo.getStoreCode())) {
                log.info("\u672c\u6b21\u62c9\u53d6\u6570\u636e\uff1a" + masterDataMdgDimChlVos);
                throw new RuntimeException("\u6765\u6e901\u4ee3\u7801" + masterDataMdgDimChlVo.getStoreCode() + "\u91cd\u590d\u62c9\u53d6\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            codeMap.put(masterDataMdgDimChlVo.getStoreCode(), "");
            TerminalServiceImpl.transformationTerminalData(tenantCode, masterDataMdgDimChlVo, terminal);
            pullList.add(terminal);
        });
        return pullList;
    }

    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u5782\u76f4\u95e8\u5e97\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("companyArea_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12);
    }

    private void deleteExtInfo(List<String> terminalCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCodes) ? 1 : 0) != 0, (String)"\u5220\u9664\u5173\u8054\u4fe1\u606f\u65f6\u7f3a\u5931\u7f16\u7801", (Object[])new Object[0]);
        this.terminalRelaOrgService.deleteByTerminalCodes(terminalCodes);
        this.terminalRelaCustomerOrgService.deleteByTerminalCodes(terminalCodes);
        this.terminalContactService.deleteByTerminalCodes(terminalCodes);
        this.terminalSupplyVoService.deleteByTerminalCodes(terminalCodes);
    }

    private Map<String, List<TerminalRelaOrgVo>> findTerminalOrgMap(List<Terminal> list) {
        List<TerminalRelaOrg> orgList;
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<Object, Object> map = Maps.newHashMap();
        Set terminalCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(terminalCodeSet) && CollectionUtils.isNotEmpty(orgList = this.terminalRelaOrgService.findByTerminalCodes(Lists.newArrayList(terminalCodeSet)))) {
            List orgVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(orgList, TerminalRelaOrg.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            map = orgVoList.stream().collect(Collectors.groupingBy(TerminalRelaOrgVo::getTerminalCode));
        }
        return map;
    }
}

