/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSignAccount;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalSignAccountRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSignAccountService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="terminalSignAccountService")
public class TerminalSignAccountServiceImpl
implements TerminalSignAccountService {
    @Autowired
    private TerminalSignAccountRepository terminalSignAccountRepository;

    @Override
    public TerminalSignAccount findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (TerminalSignAccount)((Object)this.terminalSignAccountRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public TerminalSignAccount create(TerminalSignAccount terminalSignAccount) {
        this.createValidate(terminalSignAccount);
        this.terminalSignAccountRepository.saveOrUpdate((Object)terminalSignAccount);
        return terminalSignAccount;
    }

    @Override
    @Transactional
    public TerminalSignAccount update(TerminalSignAccount terminalSignAccount) {
        this.updateValidate(terminalSignAccount);
        this.terminalSignAccountRepository.saveOrUpdate((Object)terminalSignAccount);
        return terminalSignAccount;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalSignAccount> terminalSignAccounts = this.terminalSignAccountRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalSignAccounts) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalSignAccounts.stream().forEach(terminalSignAccount -> terminalSignAccount.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.terminalSignAccountRepository.saveOrUpdateBatch(terminalSignAccounts);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalSignAccount> terminalSignAccounts = this.terminalSignAccountRepository.findEnableStatusByIds(EnableStatusEnum.DISABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalSignAccounts) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u542f\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalSignAccounts.stream().forEach(terminalSignAccount -> terminalSignAccount.setEnableStatus(EnableStatusEnum.ENABLE.getCode()));
        this.terminalSignAccountRepository.saveOrUpdateBatch(terminalSignAccounts);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalSignAccount> terminalSignAccounts = this.terminalSignAccountRepository.findEnableStatusByIds(EnableStatusEnum.ENABLE, idList);
        Validate.isTrue((!CollectionUtils.isEmpty(terminalSignAccounts) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u9700\u8981\u7981\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        terminalSignAccounts.stream().forEach(terminalSignAccount -> terminalSignAccount.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.terminalSignAccountRepository.saveOrUpdateBatch(terminalSignAccounts);
    }

    @Override
    public List<TerminalSignAccount> findByTerminalCodes(List<String> terminalCodes) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.terminalSignAccountRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(TerminalSignAccount::getTerminalCode, terminalCodes)).list();
        return list;
    }

    @Override
    public void deleteByTerminalCodes(List<String> terminalCodeList) {
        LambdaQueryWrapper lq = Wrappers.lambdaQuery();
        this.terminalSignAccountRepository.remove((Wrapper)((LambdaQueryWrapper)lq.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(TerminalSignAccount::getTerminalCode, terminalCodeList));
    }

    @Override
    public void saveBatch(List<TerminalSignAccount> accounts) {
        this.terminalSignAccountRepository.saveBatch(accounts);
    }

    private void createValidate(TerminalSignAccount terminalSignAccount) {
        Validate.notNull((Object)((Object)terminalSignAccount), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        terminalSignAccount.setId(null);
        Validate.notBlank((CharSequence)terminalSignAccount.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(TerminalSignAccount terminalSignAccount) {
        Validate.notNull((Object)((Object)terminalSignAccount), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalSignAccount.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalSignAccount.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

