/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupplyDetail;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalSupplyDetailRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyDetailService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalSupplyDetailService")
public class TerminalSupplyDetailServiceImpl
implements TerminalSupplyDetailService {
    @Autowired(required=false)
    private TerminalSupplyDetailRepository terminalSupplyDetailRepository;

    @Override
    public List<TerminalSupplyDetail> findBySupplyIds(List<String> supplyIdList) {
        if (CollectionUtils.isEmpty(supplyIdList)) {
            return Lists.newLinkedList();
        }
        return this.terminalSupplyDetailRepository.findBySupplyIds(supplyIdList);
    }

    @Override
    @Transactional
    public void saveBatch(List<TerminalSupplyDetail> list) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u4f9b\u8d27\u5173\u7cfb\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional<TerminalSupplyDetail> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getSupplyId()) || StringUtils.isBlank((CharSequence)a.getDataType()) || StringUtils.isBlank((CharSequence)a.getCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5173\u8054id\u3001\u7c7b\u578b\u3001\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet();
        list.forEach(a -> Validate.isTrue((boolean)set.add(a.getDataType() + "-" + a.getCode()), (String)"\u5b58\u5728\u91cd\u590d\u7684\u8bb0\u5f55\u4fe1\u606f", (Object[])new Object[0]));
        List<String> supplyIdList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSupplyId())).map(TerminalSupplyDetail::getSupplyId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(supplyIdList)) {
            this.terminalSupplyDetailRepository.deleteBySupplyIds(supplyIdList);
        }
        for (TerminalSupplyDetail terminalSupplyDetail : list) {
            terminalSupplyDetail.setId(null);
            terminalSupplyDetail.setTenantCode(TenantUtils.getTenantCode());
        }
        this.terminalSupplyDetailRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void deleteBySupplyIds(List<String> supplyIdList) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(supplyIdList), (String)"\u5173\u8054id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalSupplyDetailRepository.deleteBySupplyIds(supplyIdList);
    }
}

