/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserRelateCustomerVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserRelateCustomerVo;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupplyDetail;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalSupplyRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyDetailService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalBindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDetailDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalUnbindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.enums.TerminalSupplyTypeEnum;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalSupplyEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyDetailVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalSupplyService")
public class TerminalSupplyServiceImpl
implements TerminalSupplyService {
    @Autowired(required=false)
    private TerminalSupplyRepository terminalSupplyRepository;
    @Autowired(required=false)
    private TerminalSupplyDetailService terminalSupplyDetailService;
    @Autowired(required=false)
    private CustomerUserRelateCustomerVoService customerUserRelateCustomerVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<TerminalSupplyEventListener> terminalSupplyEventListeners;
    private static volatile Cache<String, List<TerminalSupply>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalSupplyServiceImpl() {
        if (cache != null) return;
        Class<TerminalSupplyServiceImpl> clazz = TerminalSupplyServiceImpl.class;
        synchronized (TerminalSupplyServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<TerminalSupply> findByTerminalCodes(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), terminalCodeList});
        List<TerminalSupply> records = (List<TerminalSupply>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalSupplyRepository.findByTerminalCodes(terminalCodeList);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    @Transactional
    public void saveBatch(Map<String, List<TerminalSupplyDto>> map) {
        map.forEach((terminalCode, list) -> {
            Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List<TerminalSupply> oldList = this.findByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
            if (CollectionUtils.isNotEmpty(oldList)) {
                this.terminalSupplyDetailService.deleteBySupplyIds(oldList.stream().map(UuidEntity::getId).collect(Collectors.toList()));
            }
            this.terminalSupplyRepository.deleteByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            this.batchSavePrevValidate((List<TerminalSupplyDto>)list, (String)terminalCode);
            List codeList = this.generateCodeService.generateCode("ZDS", list.size());
            LinkedList detailDtoList = Lists.newLinkedList();
            for (int i = 0; i < list.size(); ++i) {
                ((TerminalSupplyDto)list.get(i)).setId((String)codeList.get(i));
                ((TerminalSupplyDto)list.get(i)).setTenantCode(TenantUtils.getTenantCode());
                if (!CollectionUtils.isNotEmpty((Collection)((TerminalSupplyDto)list.get(i)).getDetails())) continue;
                for (TerminalSupplyDetailDto detail : ((TerminalSupplyDto)list.get(i)).getDetails()) {
                    detail.setSupplyId((String)codeList.get(i));
                    detail.setTenantCode(TenantUtils.getTenantCode());
                }
                detailDtoList.addAll(((TerminalSupplyDto)list.get(i)).getDetails());
            }
            this.terminalSupplyRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TerminalSupplyDto.class, TerminalSupply.class, HashSet.class, ArrayList.class, new String[0]));
            if (CollectionUtils.isNotEmpty((Collection)detailDtoList)) {
                this.terminalSupplyDetailService.saveBatch((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailDtoList, TerminalSupplyDetailDto.class, TerminalSupplyDetail.class, HashSet.class, ArrayList.class, new String[0]));
            }
        });
    }

    @Override
    @Transactional
    public void bind(TerminalBindSupplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean f = StringUtils.isBlank((CharSequence)dto.getPositionCode()) && StringUtils.isBlank((CharSequence)dto.getCustomerUserName()) && StringUtils.isBlank((CharSequence)dto.getCustomerCode());
        Validate.isTrue((f == false ? 1 : 0) != 0, (String)"\u5c97\u4f4d\u3001\u5ba2\u6237\u7528\u6237\u8d26\u53f7\u3001\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodeList()), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> supplyIdList = this.findNeedUnbindSupplyIdList(dto.getPositionCode(), dto.getCustomerUserName(), dto.getCustomerCode(), dto.getTerminalCodeList());
        if (CollectionUtils.isNotEmpty(supplyIdList)) {
            this.unbind(supplyIdList, false);
        }
        LinkedList list = Lists.newLinkedList();
        String supplyType = TerminalSupplyTypeEnum.DEFAULT.getValue();
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerUserName())) {
            supplyType = TerminalSupplyTypeEnum.CUSTOMER_USER.getValue();
        }
        for (String terminalCode : dto.getTerminalCodeList()) {
            TerminalSupply cur = new TerminalSupply();
            cur.setTerminalCode(terminalCode);
            cur.setTenantCode(TenantUtils.getTenantCode());
            cur.setSupplyType(supplyType);
            cur.setPositionCode("");
            cur.setCustomerCode("");
            cur.setUserName("");
            if (StringUtils.isNotBlank((CharSequence)dto.getPositionCode())) {
                cur.setPositionCode(dto.getPositionCode());
            } else if (StringUtils.isNotBlank((CharSequence)dto.getCustomerUserName())) {
                cur.setUserName(dto.getCustomerUserName());
            } else {
                cur.setCustomerCode(dto.getCustomerCode());
            }
            list.add(cur);
        }
        this.terminalSupplyRepository.saveBatch(list);
        if (CollectionUtils.isEmpty(this.terminalSupplyEventListeners)) {
            return;
        }
        for (TerminalSupplyEventListener terminalSupplyEventListener : this.terminalSupplyEventListeners) {
            terminalSupplyEventListener.onBind(dto.getPositionCode(), dto.getCustomerUserName(), dto.getCustomerCode(), dto.getTerminalCodeList());
        }
    }

    @Override
    @Transactional
    public void unbind(TerminalUnbindSupplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean f = StringUtils.isBlank((CharSequence)dto.getPositionCode()) && StringUtils.isBlank((CharSequence)dto.getCustomerUserName()) && StringUtils.isBlank((CharSequence)dto.getCustomerCode());
        Validate.isTrue((f == false ? 1 : 0) != 0, (String)"\u5c97\u4f4d\u3001\u5ba2\u6237\u7528\u6237\u8d26\u53f7\u3001\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodeList()), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> supplyIdList = this.findNeedUnbindSupplyIdList(dto.getPositionCode(), dto.getCustomerUserName(), dto.getCustomerCode(), dto.getTerminalCodeList());
        this.unbind(supplyIdList, true);
    }

    @Override
    @Transactional
    public void unbindByCustomer(TerminalUnbindSupplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodeList()), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<TerminalSupply> list = this.terminalSupplyRepository.findByCustomerCodeAndTerminalCodesAndSupplyType(dto.getCustomerCode(), dto.getTerminalCodeList(), "");
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<TerminalSupply>> map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSupplyType())).collect(Collectors.groupingBy(TerminalSupply::getSupplyType));
        List<TerminalSupply> list1 = map.get(TerminalSupplyTypeEnum.DEFAULT.getValue());
        List<String> list2 = map.getOrDefault(TerminalSupplyTypeEnum.CUSTOMER_USER.getValue(), Lists.newLinkedList()).stream().map(UuidEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list2)) {
            this.unbind(list2, true);
        }
        if (CollectionUtils.isNotEmpty(list1)) {
            for (TerminalSupply item : list1) {
                item.setCustomerCode("");
                item.setTenantCode(TenantUtils.getTenantCode());
            }
            this.terminalSupplyRepository.saveOrUpdateBatch(list1);
        }
    }

    @Override
    @Transactional
    public void rebind(TerminalRebindSupplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean f = StringUtils.isBlank((CharSequence)dto.getPositionCode()) && StringUtils.isBlank((CharSequence)dto.getCustomerUserName()) && StringUtils.isBlank((CharSequence)dto.getCustomerCode());
        Validate.isTrue((f == false ? 1 : 0) != 0, (String)"\u5c97\u4f4d\u3001\u5ba2\u6237\u7528\u6237\u8d26\u53f7\u3001\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodeList()), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> supplyIdList = this.findNeedUnbindSupplyIdList(dto.getPositionCode(), dto.getCustomerUserName(), dto.getCustomerCode(), dto.getTerminalCodeList());
        this.unbind(supplyIdList, true);
        TerminalBindSupplyDto dto1 = new TerminalBindSupplyDto();
        dto1.setCustomerCode(dto.getCurCustomerCode());
        dto1.setCustomerUserName(dto.getCurCustomerUserName());
        dto1.setPositionCode(dto.getCurPositionCode());
        dto1.setTerminalCodeList(dto.getTerminalCodeList());
        this.bind(dto1);
    }

    @Override
    @Transactional
    public void rebindByCustomer(TerminalRebindSupplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCurCustomerCode(), (String)"\u66ff\u6362\u540e\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodeList()), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<TerminalSupply> list = this.terminalSupplyRepository.findByCustomerCodeAndTerminalCodesAndSupplyType(dto.getCustomerCode(), dto.getTerminalCodeList(), "");
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<TerminalSupply>> map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSupplyType())).collect(Collectors.groupingBy(TerminalSupply::getSupplyType));
        List<TerminalSupply> list1 = map.get(TerminalSupplyTypeEnum.DEFAULT.getValue());
        List<TerminalSupply> list2 = map.get(TerminalSupplyTypeEnum.CUSTOMER_USER.getValue());
        if (CollectionUtils.isNotEmpty(list2)) {
            List<String> unbindSupplyIds = list2.stream().map(UuidEntity::getId).collect(Collectors.toList());
            this.unbind(unbindSupplyIds, true);
            List userRelateCustomerVoList = this.customerUserRelateCustomerVoService.findByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{dto.getCurCustomerCode()}));
            Optional optional = userRelateCustomerVoList.stream().findFirst();
            if (optional.isPresent()) {
                TerminalBindSupplyDto dto1 = new TerminalBindSupplyDto();
                dto1.setCustomerCode(dto.getCurCustomerCode());
                dto1.setCustomerUserName(((CustomerUserRelateCustomerVo)optional.get()).getUserName());
                dto1.setTerminalCodeList(list2.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(TerminalSupply::getTerminalCode).distinct().collect(Collectors.toList()));
                this.bind(dto1);
            }
        }
        if (CollectionUtils.isNotEmpty(list1)) {
            for (TerminalSupply item : list1) {
                item.setCustomerCode(dto.getCurCustomerCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            }
            this.terminalSupplyRepository.saveOrUpdateBatch(list1);
        }
    }

    @Override
    public void deleteByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        this.terminalSupplyRepository.deleteByTerminalCodes(terminalCodes);
    }

    @Override
    public List<TerminalSupply> findByUserNames(List<String> userNameList) {
        if (CollectionUtils.isEmpty(userNameList)) {
            return new ArrayList<TerminalSupply>(0);
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), userNameList});
        List<TerminalSupply> records = (List<TerminalSupply>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalSupplyRepository.findByUserNames(userNameList, TerminalSupplyTypeEnum.CUSTOMER_USER.getValue());
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public List<TerminalSupply> findByCustomerCodes(Set<String> customerCodeSet) {
        if (CollectionUtils.isEmpty(customerCodeSet)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), customerCodeSet});
        List<TerminalSupply> records = (List<TerminalSupply>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalSupplyRepository.findByCustomerCodes(customerCodeSet);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public List<TerminalSupply> findByPositionCodes(Set<String> positionCodeSet) {
        if (CollectionUtils.isEmpty(positionCodeSet)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), positionCodeSet});
        List<TerminalSupply> records = (List<TerminalSupply>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalSupplyRepository.findByPositionCodes(positionCodeSet);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Transactional
    public void unbind(List<String> supplyIdList, Boolean needNotifier) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(supplyIdList), (String)"\u4f9b\u8d27\u5173\u7cfbid\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<TerminalSupply> supplyList = this.terminalSupplyRepository.findByIds(supplyIdList);
        List<TerminalSupplyDetail> supplyDetailList = this.terminalSupplyDetailService.findBySupplyIds(supplyIdList);
        this.terminalSupplyDetailService.deleteBySupplyIds(supplyIdList);
        this.terminalSupplyRepository.removeByIdsAndTenantCode(supplyIdList, TenantUtils.getTenantCode());
        if (Boolean.FALSE.equals(needNotifier)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.terminalSupplyEventListeners)) {
            return;
        }
        List supplyVoList = Lists.newLinkedList();
        List supplyDetailVoList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(supplyList)) {
            supplyVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(supplyList, TerminalSupply.class, TerminalSupplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        if (CollectionUtils.isNotEmpty(supplyDetailList)) {
            supplyDetailVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(supplyDetailList, TerminalSupplyDetail.class, TerminalSupplyDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        for (TerminalSupplyEventListener terminalSupplyEventListener : this.terminalSupplyEventListeners) {
            terminalSupplyEventListener.onUnbind(supplyVoList, supplyDetailVoList);
        }
    }

    private List<String> findNeedUnbindSupplyIdList(String positionCode, String customerUserName, String customerCode, List<String> terminalCodeList) {
        if (StringUtils.isNotBlank((CharSequence)positionCode)) {
            return this.findNeedUnbindByPositionCode(positionCode, terminalCodeList);
        }
        if (StringUtils.isNotBlank((CharSequence)customerUserName)) {
            return this.findNeedUnbindByCustomerUserName(customerUserName, terminalCodeList);
        }
        if (StringUtils.isNotBlank((CharSequence)customerCode)) {
            return this.findNeedUnbindByCustomerCode(customerCode, terminalCodeList);
        }
        return Lists.newLinkedList();
    }

    private List<String> findNeedUnbindByPositionCode(String positionCode, List<String> terminalCodeList) {
        LinkedList re = Lists.newLinkedList();
        if (StringUtils.isBlank((CharSequence)positionCode)) {
            return re;
        }
        List<TerminalSupply> list = this.terminalSupplyRepository.findByPositionCodesAndTerminalCodes(Lists.newArrayList((Object[])new String[]{positionCode}), terminalCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return re;
        }
        return list.stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    private List<String> findNeedUnbindByCustomerUserName(String customerUserName, List<String> terminalCodeList) {
        LinkedList re = Lists.newLinkedList();
        if (StringUtils.isBlank((CharSequence)customerUserName)) {
            return re;
        }
        List<TerminalSupply> list = this.terminalSupplyRepository.findByCustomerUserNameAndTerminalCodes(customerUserName, terminalCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return re;
        }
        return list.stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    private List<String> findNeedUnbindByCustomerCode(String customerCode, List<String> terminalCodeList) {
        LinkedList re = Lists.newLinkedList();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return re;
        }
        List<TerminalSupply> list = this.terminalSupplyRepository.findByCustomerCodeAndTerminalCodesAndSupplyType(customerCode, terminalCodeList, TerminalSupplyTypeEnum.DEFAULT.getValue());
        if (CollectionUtils.isEmpty(list)) {
            return re;
        }
        return list.stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    private void batchSavePrevValidate(List<TerminalSupplyDto> list, String terminalCode) {
        Optional<TerminalSupplyDto> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getTerminalCode()) || StringUtils.isBlank((CharSequence)a.getSupplyType()) || !terminalCode.equals(a.getTerminalCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u3001\u4f9b\u8d27\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u7ec8\u7aef", (Object[])new Object[0]);
        list.forEach(a -> {
            Validate.isTrue((boolean)TerminalSupplyTypeEnum.exists((String)a.getSupplyType()), (String)"\u4f9b\u8d27\u7c7b\u578b\u53c2\u6570\u5f02\u5e38", (Object[])new Object[0]);
            if (TerminalSupplyTypeEnum.DEFAULT.getValue().equals(a.getSupplyType())) {
                Validate.notBlank((CharSequence)a.getPositionCode(), (String)"\u5b58\u5728\u672a\u9009\u62e9\u8d1f\u8d23\u4fe1\u606f\u7684\u8bb0\u5f55", (Object[])new Object[0]);
            } else {
                Validate.notBlank((CharSequence)a.getUserName(), (String)"\u5b58\u5728\u672a\u9009\u62e9\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7684\u8bb0\u5f55", (Object[])new Object[0]);
            }
        });
        HashSet set = Sets.newHashSet();
        list.forEach(a -> Validate.isTrue((boolean)set.add(StringUtils.join((Iterable)Lists.newArrayList((Object[])new String[]{a.getSupplyType(), Optional.ofNullable(a.getPositionCode()).orElse(""), Optional.ofNullable(a.getUserName()).orElse("")}), (char)'-')), (String)"\u5b58\u5728\u91cd\u590d\u7684\u4f9b\u8d27\u5173\u7cfb\u8bb0\u5f55\u4fe1\u606f", (Object[])new Object[0]));
    }
}

