/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.org.sdk.service.CustomerOrgVoSdkService;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalCustomer;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalCustomerStaff;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaCustomerOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSignAccount;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRelaOrgRepository;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalCustomerService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalCustomerVoService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaCustomerOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSignAccountService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSignAccountVoService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalTagService;
import com.biz.crm.mdm.business.terminal.sdk.dto.CustomerTerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.CustomerTerminalValidateDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalContactDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCustomerDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDistanceQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRegionRetailerCityDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelaCustomerOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelaOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSignAccountDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.CustomerTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalCusVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalCustomerVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaCustomerOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSignAccountVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TerminalVoServiceImpl
implements TerminalVoService {
    private static final Logger log = LoggerFactory.getLogger(TerminalVoServiceImpl.class);
    @Autowired(required=false)
    private TerminalService terminalService;
    @Autowired(required=false)
    private TerminalRelaOrgService terminalRelaOrgService;
    @Autowired(required=false)
    private TerminalRelaCustomerOrgService terminalRelaCustomerOrgService;
    @Autowired(required=false)
    private TerminalContactService terminalContactService;
    @Autowired(required=false)
    private TerminalSupplyVoService terminalSupplyVoService;
    @Autowired(required=false)
    private TerminalCustomerService terminalCustomerService;
    @Autowired(required=false)
    private TerminalSignAccountService terminalSignAccountService;
    @Autowired(required=false)
    private TerminalCustomerVoService terminalCustomerVoService;
    @Autowired(required=false)
    private TerminalSignAccountVoService terminalSignAccountVoService;
    @Autowired(required=false)
    private TerminalSupplyService terminalSupplyService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerOrgVoSdkService customerOrgVoSdkService;
    @Autowired(required=false)
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private TerminalRelaOrgRepository terminalRelaOrgRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private TerminalTagService terminalTagService;
    @Autowired
    DictDataVoService dictDataVoService;
    public static final String TERMINAL_PROCESS_NAME = "\u7ec8\u7aef\u5ba1\u6279\u6d41\u7a0b";
    private static volatile Cache<String, List<TerminalVo>> cache = null;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Value(value="${crm.business.terminal.process-key:}")
    private String defaultProcessKey;

    public List<TerminalVo> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes) {
        List<Object> re = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids) && org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodes)) {
            return re;
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(ids, terminalCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return re;
        }
        re = this.convertEntityToVo(terminalList);
        return re;
    }

    public List<TerminalVo> findDetailsByTerminalCodesPOST(List<String> terminalCodes) {
        return this.findDetailsByIdsOrTerminalCodes(null, terminalCodes);
    }

    @Transactional
    public TerminalVo create(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getTerminalCode())) {
            dto.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(dto.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(dto.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        terminal.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(Collections.singletonList(dto));
        this.terminalService.create(terminal);
        return this.buildByDtoAndTerminal(dto, terminal);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TerminalVo> createOrUpdate(List<TerminalDto> dtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        HashSet codeSet = new HashSet(dtoList.size());
        dtoList.forEach(dto -> {
            Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
            String code = dto.getTerminalCode();
            Validate.notEmpty((CharSequence)code, (String)"\u7ec8\u7aef\u7f16\u7801\u7f3a\u5931", (Object[])new Object[0]);
            Assert.isTrue((!codeSet.contains(code) ? 1 : 0) != 0, (String)("\u5f53\u524d\u96c6\u5408\u5185\u7f16\u7801[" + code + "]\u91cd\u590d"));
            dto.setTenantCode(TenantUtils.getTenantCode());
            codeSet.add(code);
        });
        Validate.notNull(dtoList, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        String redisKey = "mdm:terminal:add_edit";
        HashSet hasLockSet = new HashSet(codeSet.size());
        try {
            codeSet.forEach(code -> {
                boolean lock = this.redisMutexService.tryLock(redisKey + code, TimeUnit.MINUTES, 30);
                Assert.isTrue((boolean)lock, (String)("\u4fc3\u9500\u4eba\u5458[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
                hasLockSet.add(code);
            });
            List<Terminal> oldEntityList = this.terminalRepository.findByCodes(new ArrayList<String>(codeSet));
            HashMap<String, Terminal> oldMap = new HashMap<String, Terminal>(codeSet.size());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(oldEntityList)) {
                oldEntityList.forEach(entity -> oldMap.put(entity.getTerminalCode(), (Terminal)((Object)entity)));
            }
            List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList, TerminalDto.class, Terminal.class, HashSet.class, ArrayList.class, new String[0]);
            List<Terminal> addList = this.buildAddMap(entityList, oldMap);
            List<Terminal> updateList = this.buildUpdateMap(entityList, oldMap);
            this.bindExtInfo(dtoList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(addList)) {
                this.terminalRepository.saveBatch(addList);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateList)) {
                this.terminalRepository.updateBatchById(updateList);
            }
            ArrayList<Terminal> terminalList = new ArrayList<Terminal>();
            terminalList.addAll(addList);
            terminalList.addAll(updateList);
            List<TerminalVo> list = this.convertEntityToVo(terminalList);
            return list;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hasLockSet)) {
                hasLockSet.forEach(code -> this.redisMutexService.unlock(redisKey + code));
            }
        }
    }

    private List<Terminal> buildAddMap(List<Terminal> entityList, Map<String, Terminal> oldMap) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<Terminal> result = new ArrayList<Terminal>(entityList.size());
        entityList.stream().filter(k -> !oldMap.containsKey(k.getTerminalCode())).filter(k -> Objects.isNull(oldMap.get(k.getTerminalCode()))).forEach(entity -> {
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            result.add((Terminal)((Object)entity));
        });
        return result;
    }

    private List<Terminal> buildUpdateMap(List<Terminal> entityList, Map<String, Terminal> oldMap) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<Terminal> result = new ArrayList<Terminal>(entityList.size());
        entityList.stream().filter(k -> oldMap.containsKey(k.getTerminalCode())).filter(k -> Objects.nonNull(oldMap.get(k.getTerminalCode()))).forEach(entity -> {
            Terminal oldEntity = (Terminal)((Object)((Object)oldMap.get(entity.getTerminalCode())));
            entity.setId(oldEntity.getId());
            entity.setCreateTime(oldEntity.getCreateTime());
            entity.setCreateName(oldEntity.getCreateName());
            entity.setCreateAccount(oldEntity.getCreateAccount());
            result.add((Terminal)((Object)entity));
        });
        return result;
    }

    @Transactional
    public TerminalVo createAndSubmit(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getTerminalCode())) {
            dto.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(dto.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(dto.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(Collections.singletonList(dto));
        this.terminalService.create(terminal);
        TerminalVo re = this.buildByDtoAndTerminal(dto, terminal);
        dto.setId(terminal.getId());
        terminal.setProcessNumber(this.commitProcess(dto));
        terminal.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        this.terminalRepository.updateById((Object)terminal);
        return re;
    }

    @Transactional
    public TerminalVo update(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(Collections.singletonList(dto));
        this.terminalService.update(terminal);
        return this.buildByDtoAndTerminal(dto, terminal);
    }

    public List<TerminalVo> findSelectByKeyword(String keyword) {
        PageRequest pageable = PageRequest.of((int)0, (int)20);
        TerminalPaginationDto dto = new TerminalPaginationDto();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setKeyword(keyword);
        Page<Terminal> page = this.terminalService.findByConditions((Pageable)pageable, dto);
        if (Objects.isNull(page) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return Lists.newLinkedList();
        }
        ArrayList list = Lists.newArrayList();
        for (Terminal item : page.getRecords()) {
            TerminalVo cur = new TerminalVo();
            cur.setTerminalCode(item.getTerminalCode());
            cur.setTerminalName(item.getTerminalName());
            list.add(cur);
        }
        return list;
    }

    public List<TerminalVo> findMainDetailsByTerminalCodesUsePost(List<String> terminalCodeList) {
        return this.findMainDetailsByTerminalCodes(terminalCodeList);
    }

    public List<TerminalVo> findTerminalAndContactByTerminalCodes(List<String> terminalCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(null, terminalCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return Lists.newLinkedList();
        }
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        List terminalContactVos = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)terminalContactVos)) {
            terminalContactVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        Map<String, List<TerminalContactVo>> terminalContactVoMap = terminalContactVos.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        List terminalVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        terminalVos.forEach(terminalVo -> terminalVo.setContacts((List)terminalContactVoMap.get(terminalVo.getTerminalCode())));
        return terminalVos;
    }

    public List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(null, terminalCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return Lists.newLinkedList();
        }
        List<TerminalRelaOrg> terminalRelaOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodeList);
        Map map = terminalRelaOrgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()})).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toList())));
        Set orgCodeSet = terminalRelaOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrg::getOrgCode).collect(Collectors.toSet());
        List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodeSet));
        Map<Object, Object> mapOrg = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgVoList)) {
            mapOrg = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getOrgName()})).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
        }
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        Map<Object, Object> terminalContactVoMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(terminalContactList)) {
            List terminalContactVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
            terminalContactVoMap = terminalContactVos.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        }
        List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgs = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodeList);
        Map<Object, Object> terminalRelaCustomerOrgVoMap = new HashMap();
        Map<Object, Object> customerOrgVoMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(terminalRelaCustomerOrgs)) {
            List terminalRelaCustomerOrgVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaCustomerOrgs, TerminalRelaCustomerOrg.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            terminalRelaCustomerOrgVoMap = terminalRelaCustomerOrgVos.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrgVo::getTerminalCode));
            List customerOrgVos = this.customerOrgVoSdkService.findListByCodes(terminalRelaCustomerOrgVos.stream().map(TerminalRelaCustomerOrgVo::getOrgCode).collect(Collectors.toList()));
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerOrgVos)) {
                customerOrgVoMap = customerOrgVos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerOrgCode(), a.getCustomerOrgName()})).collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, CustomerOrgVo::getCustomerOrgName));
            }
        }
        List re = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo item : re) {
            List terminalRelaCustomerOrgVos;
            List terminalContactVos;
            List curOrgCodeList = map.get(item.getTerminalCode());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(curOrgCodeList)) {
                LinkedList curList = Lists.newLinkedList();
                LinkedList orgNameList = Lists.newLinkedList();
                for (String orgCode : curOrgCodeList) {
                    TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
                    cur.setTerminalCode(item.getTerminalCode());
                    cur.setOrgCode(orgCode);
                    cur.setOrgName((String)mapOrg.get(orgCode));
                    curList.add(cur);
                    orgNameList.add(cur.getOrgName());
                }
                item.setOrgList((List)curList);
                item.setOrgNameStr(StringUtils.join((Iterable)orgNameList, (String)","));
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(terminalContactVos = (List)terminalContactVoMap.get(item.getTerminalCode())))) {
                item.setContacts(terminalContactVos);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(terminalRelaCustomerOrgVos = (List)terminalRelaCustomerOrgVoMap.get(item.getTerminalCode())))) continue;
            for (TerminalRelaCustomerOrgVo terminalRelaCustomerOrgVo : terminalRelaCustomerOrgVos) {
                terminalRelaCustomerOrgVo.setOrgName((String)customerOrgVoMap.get(terminalRelaCustomerOrgVo.getOrgCode()));
            }
            item.setCustomerOrgList(terminalRelaCustomerOrgVos);
        }
        return re;
    }

    public Page<TerminalVo> findByTerminalPaginationDto(Pageable pageable, TerminalPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Terminal> entityPage = this.terminalRepository.findByConditions((Page<Terminal>)page, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        pageResult.setRecords(this.convertEntityToVo(entityPage.getRecords()));
        return pageResult;
    }

    public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        dto = Optional.ofNullable(dto).orElse(new TerminalCodeSearchDto());
        return this.terminalService.findByTerminalCodeSearchDto(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<TerminalVo> findByAmapIds(Set<String> amapIds) {
        List<TerminalVo> graph;
        String cacheKey = StringUtils.join((Object[])new Set[]{amapIds});
        if (cache == null) {
            Class<TerminalVoServiceImpl> clazz = TerminalVoServiceImpl.class;
            // MONITORENTER : com.biz.crm.mdm.business.terminal.local.service.internal.TerminalVoServiceImpl.class
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(300L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // MONITOREXIT : clazz
        }
        if ((graph = (List<TerminalVo>)cache.getIfPresent((Object)cacheKey)) != null) return graph;
        graph = this.findByAmapIdsFromDB(amapIds);
        cache.put((Object)cacheKey, graph);
        return graph;
    }

    private List<TerminalVo> findByAmapIdsFromDB(Set<String> amapIds) {
        log.warn(" db \u67e5\u8be2 findByAmapIds ");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(amapIds)) {
            return Lists.newArrayList();
        }
        List<Terminal> list = this.terminalRepository.findByAmapIds(amapIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void submitAudit(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Terminal terminal = this.terminalRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet((Object[])new String[]{ProcessStatusEnum.PREPARE.getDictCode(), ProcessStatusEnum.REJECT.getDictCode(), ProcessStatusEnum.RECOVER.getDictCode()});
        Validate.isTrue((boolean)set.contains(terminal.getProcessStatus()), (String)"\u7ec8\u7aef\u72b6\u6001\u4e0d\u80fd\u6267\u884c\u63d0\u4ea4\u5ba1\u6838", (Object[])new Object[0]);
        dto.setTerminalCode(terminal.getTerminalCode());
        terminal.setProcessNumber(this.commitProcess(dto));
        terminal.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        terminal.setProcessRemark(processBusiness.getRemark());
        terminal.setProcessKey(processBusiness.getProcessKey());
        this.terminalRepository.updateById((Object)terminal);
    }

    public Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getTerminalCode(), dto.getTerminalName(), dto.getChannel(), dto.getOrgName(), dto.getDelFlag(), dto.getProcessStatus()})) {
            return Sets.newHashSet();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            OrgQueryDto queryDto = new OrgQueryDto();
            queryDto.setOrgName(dto.getOrgName());
            Set orgCodeSet = this.orgVoService.findByOrgQueryDto(queryDto);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgCodeSet)) {
                return Sets.newHashSet();
            }
            dto.setOrgCodeSet(orgCodeSet);
        }
        return this.terminalRepository.findByTerminalQueryDto(dto);
    }

    public Map<String, Set<String>> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Maps.newHashMap();
        }
        RelateOrgCodeQueryDto queryDto = new RelateOrgCodeQueryDto();
        queryDto.setOrgCodeSet(orgCodes);
        queryDto.setSearchType(Integer.valueOf(-1));
        Map orgRuleMap = this.orgVoService.findByRelateOrgCodeQueryDto(queryDto);
        if (CollectionUtils.isEmpty((Map)orgRuleMap)) {
            return Maps.newHashMap();
        }
        List<TerminalRelaOrg> list = this.terminalRelaOrgRepository.findAllowSaleTerminalByOrgCodes(orgRuleMap.keySet());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()}) && orgRuleMap.keySet().contains(a.getOrgCode())).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toSet())));
        HashMap re = Maps.newHashMap();
        for (Map.Entry item : map.entrySet()) {
            HashSet rule = Sets.newHashSet();
            for (String orgCode : item.getValue()) {
                String s = (String)orgRuleMap.get(orgCode);
                if (StringUtils.isBlank((CharSequence)s)) continue;
                rule.add(s);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rule)) continue;
            re.put(item.getKey(), rule);
        }
        return re;
    }

    public List<TerminalVo> findByTerminalSearchDto(TerminalSearchDto dto) {
        dto = Optional.ofNullable(dto).orElse(new TerminalSearchDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getOrgCodeSet()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getChannelSet()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getTagSet()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getTerminalCodeSet())) {
            return Lists.newArrayList();
        }
        List<Terminal> terminalList = this.terminalRepository.findByTerminalSearchDto(dto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, Map<String, String>> findTerminalBycusCodes(List<List<String>> codeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codeList)) {
            return Maps.newHashMap();
        }
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        List<TerminalCusVo> list = this.terminalRepository.findTerminalBycusCodes(codeList, TenantUtils.getTenantCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return map;
        }
        for (TerminalCusVo cusVo : list) {
            if (map.containsKey(cusVo.getCustomerCode())) {
                ((Map)map.get(cusVo.getCustomerCode())).put(cusVo.getTerminalCode(), cusVo.getTerminalName());
                if (!StringUtils.isNotBlank((CharSequence)cusVo.getLowerTerminalCode()) || !StringUtils.isNotBlank((CharSequence)cusVo.getLowerTerminalName())) continue;
                ((Map)map.get(cusVo.getCustomerCode())).put(cusVo.getLowerTerminalCode(), cusVo.getLowerTerminalName());
                continue;
            }
            HashMap<String, String> terMap = new HashMap<String, String>();
            terMap.put(cusVo.getTerminalCode(), cusVo.getTerminalName());
            if (StringUtils.isNotBlank((CharSequence)cusVo.getLowerTerminalCode()) && StringUtils.isNotBlank((CharSequence)cusVo.getLowerTerminalName())) {
                terMap.put(cusVo.getLowerTerminalCode(), cusVo.getLowerTerminalName());
            }
            map.put(cusVo.getCustomerCode(), terMap);
        }
        return map;
    }

    public Map<String, String> findTerminalRegion() {
        List<CommonSelectVo> list = this.terminalRepository.findTerminalRegion(TenantUtils.getTenantCode());
        Map<String, String> map = new HashMap<String, String>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(CommonSelectVo::getCode, CommonSelectVo::getValue));
        }
        return map;
    }

    public Map<String, String> findTerminalRegionByCodes(List<String> codes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codes)) {
            return Maps.newHashMap();
        }
        List codeList = Lists.partition(codes, (int)500);
        List<TerminalVo> list = this.terminalRepository.findTerminalRegionByCodes(codeList, TenantUtils.getTenantCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(TerminalVo::getRegionCode, TerminalVo::getRegionName, (oldValue, newValue) -> newValue));
    }

    public List<TerminalVo> findBaseByTerminalCodes(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        List<Terminal> list = this.terminalService.findByTerminalCodes(terminalCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalVo> findListByConditions(TerminalPaginationDto dto) {
        if (StringUtils.isEmpty((CharSequence)(dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto())).getRegionCode()) && StringUtils.isEmpty((CharSequence)dto.getCustomerRetailerCode())) {
            throw new RuntimeException("\u533a\u57df\u6216\u8005\u96f6\u552e\u5546\u54c1\u5fc5\u987b\u8f93\u5165");
        }
        List<Object> byConditions = new ArrayList<TerminalVo>();
        List<Terminal> terminalList = this.terminalRepository.findListByConditions(dto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return byConditions;
        }
        List terminalVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, Terminal.class, TerminalVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        byConditions = terminalVos;
        return byConditions;
    }

    private void bindExtInfo(List<TerminalDto> dtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<String> terminalCodeList = dtoList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getTerminalCode())).map(TerminalDto::getTerminalCode).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return;
        }
        this.terminalRelaOrgService.deleteByTerminalCodes(terminalCodeList);
        this.terminalRelaCustomerOrgService.deleteByTerminalCodes(terminalCodeList);
        this.terminalContactService.deleteByTerminalCodes(terminalCodeList);
        this.terminalSupplyService.deleteByTerminalCodes(terminalCodeList);
        this.terminalCustomerService.deleteByTerminalCodes(terminalCodeList);
        this.terminalSignAccountService.deleteByTerminalCodes(terminalCodeList);
        ArrayList relaOrgDtoList = new ArrayList();
        ArrayList relaCustomerOrgDtoList = new ArrayList();
        ArrayList contactDtoList = new ArrayList();
        ArrayList supplyDtoList = new ArrayList();
        dtoList.forEach(dto -> {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getOrgList())) {
                for (TerminalRelaOrgDto item : dto.getOrgList()) {
                    item.setTerminalCode(dto.getTerminalCode());
                    relaOrgDtoList.add(item);
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerOrgList())) {
                for (TerminalRelaOrgDto item : dto.getCustomerOrgList()) {
                    item.setTerminalCode(dto.getTerminalCode());
                    relaCustomerOrgDtoList.add(item);
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerList())) {
                List<TerminalCustomer> customers = dto.getCustomerList().stream().map(s -> {
                    TerminalCustomer customer = new TerminalCustomer();
                    BeanUtils.copyProperties((Object)s, (Object)((Object)customer));
                    customer.setId(null);
                    customer.setTenantCode(TenantUtils.getTenantCode());
                    customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    customer.setTerminalCode(dto.getTerminalCode());
                    customer.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    List staff = s.getStaff();
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)staff)) {
                        customer.setStaff(staff.stream().map(m -> {
                            TerminalCustomerStaff staff1 = new TerminalCustomerStaff();
                            BeanUtils.copyProperties((Object)m, (Object)((Object)staff1));
                            staff1.setId(null);
                            staff1.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                            staff1.setTerminalCode(dto.getTerminalCode());
                            staff1.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                            staff1.setTerminalCode(dto.getTerminalCode());
                            staff1.setCustomerCode(s.getCustomerCode());
                            return staff1;
                        }).collect(Collectors.toList()));
                    }
                    return customer;
                }).collect(Collectors.toList());
                this.terminalCustomerService.saveBatch(customers);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getTerminalSignAccountList())) {
                List accounts = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getTerminalSignAccountList(), TerminalSignAccountDto.class, TerminalSignAccount.class, HashSet.class, ArrayList.class, new String[0]);
                accounts.forEach(s -> {
                    s.setId(null);
                    s.setTenantCode(TenantUtils.getTenantCode());
                    s.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    s.setTerminalCode(dto.getTerminalCode());
                    s.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                });
                this.terminalSignAccountService.saveBatch(accounts);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getContacts())) {
                for (TerminalRelaOrgDto item : dto.getContacts()) {
                    item.setTerminalCode(dto.getTerminalCode());
                    contactDtoList.add(item);
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getSupplys())) {
                for (TerminalRelaOrgDto item : dto.getSupplys()) {
                    item.setTerminalCode(dto.getTerminalCode());
                    supplyDtoList.add(item);
                }
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relaOrgDtoList)) {
            List relaOrgList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(relaOrgDtoList, TerminalRelaOrgDto.class, TerminalRelaOrg.class, HashSet.class, ArrayList.class, new String[0]);
            this.terminalRelaOrgService.saveBatch(relaOrgList.stream().collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode)));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relaCustomerOrgDtoList)) {
            List relaCustomerOrgList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(relaCustomerOrgDtoList, TerminalRelaCustomerOrgDto.class, TerminalRelaCustomerOrg.class, HashSet.class, ArrayList.class, new String[0]);
            this.terminalRelaCustomerOrgService.saveBatch(relaCustomerOrgList.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrg::getTerminalCode)));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contactDtoList)) {
            List contactList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(contactDtoList, TerminalContactDto.class, TerminalContact.class, HashSet.class, ArrayList.class, new String[0]);
            this.terminalContactService.saveBatch(contactList.stream().collect(Collectors.groupingBy(TerminalContact::getTerminalCode)));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(supplyDtoList)) {
            this.terminalSupplyService.saveBatch(supplyDtoList.stream().collect(Collectors.groupingBy(TerminalSupplyDto::getTerminalCode)));
        }
    }

    private TerminalVo buildByDtoAndTerminal(TerminalDto dto, Terminal terminal) {
        TerminalVo vo = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getOrgList())) {
            vo.setOrgList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getOrgList(), TerminalRelaOrgDto.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerOrgList())) {
            vo.setCustomerOrgList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerOrgList(), TerminalRelaCustomerOrgDto.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getContacts())) {
            vo.setContacts((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getContacts(), TerminalContactDto.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getSupplys())) {
            vo.setSupplys((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getSupplys(), TerminalSupplyDto.class, TerminalSupplyVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getTerminalSignAccountList())) {
            vo.setTerminalSignAccountList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getTerminalSignAccountList(), TerminalSignAccountDto.class, TerminalSignAccountVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerList())) {
            vo.setCustomerList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerList(), TerminalCustomerDto.class, TerminalCustomerVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }

    private List<TerminalVo> buildTerminalVoList(List<Terminal> terminalList, List<TerminalRelaOrg> terminalRelaOrgList, List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgList, List<TerminalContact> terminalContactList, List<TerminalSupplyVo> terminalSupplyVoList, List<TerminalCustomerVo> terminalCustomerVoList, List<TerminalSignAccountVo> accountVos) {
        List list;
        List<TerminalVo> re = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<Object, Object> mapOrg = Maps.newHashMap();
        Map<Object, Object> mapCustomerOrg = Maps.newHashMap();
        Map<Object, Object> mapContact = Maps.newHashMap();
        Map<Object, Object> mapSupply = Maps.newHashMap();
        Map<Object, Object> mapCustomer = Maps.newHashMap();
        Map<Object, Object> mapAccounts = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalRelaOrgList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaOrgList, TerminalRelaOrg.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapOrg = list.stream().collect(Collectors.groupingBy(TerminalRelaOrgVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalRelaCustomerOrgList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaCustomerOrgList, TerminalRelaCustomerOrg.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapCustomerOrg = list.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrgVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalContactList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapContact = list.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalSupplyVoList)) {
            mapSupply = terminalSupplyVoList.stream().collect(Collectors.groupingBy(TerminalSupplyVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalCustomerVoList)) {
            mapCustomer = terminalCustomerVoList.stream().collect(Collectors.groupingBy(TerminalCustomerVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(accountVos)) {
            mapAccounts = accountVos.stream().collect(Collectors.groupingBy(TerminalSignAccountVo::getTerminalCode));
        }
        for (TerminalVo vo : re) {
            vo.setOrgList((List)mapOrg.get(vo.getTerminalCode()));
            vo.setCustomerOrgList((List)mapCustomerOrg.get(vo.getTerminalCode()));
            vo.setContacts((List)mapContact.get(vo.getTerminalCode()));
            vo.setSupplys((List)mapSupply.get(vo.getTerminalCode()));
            vo.setCustomerList((List)mapCustomer.get(vo.getTerminalCode()));
            vo.setTerminalSignAccountList((List)mapAccounts.get(vo.getTerminalCode()));
        }
        return re;
    }

    private void validateContacts(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List contacts = dto.getContacts();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)contacts)) {
            return;
        }
        for (TerminalContactDto contact : contacts) {
            if (!StringUtils.isNotBlank((CharSequence)contact.getContactName()) && !StringUtils.isNotBlank((CharSequence)contact.getContactPhone()) && Objects.isNull(contact.getContactMain())) continue;
            Validate.notBlank((CharSequence)contact.getContactPhone(), (String)"\u7f3a\u5931\u8054\u7cfb\u7535\u8bdd", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contact.getContactName(), (String)"\u7f3a\u5931\u59d3\u540d", (Object[])new Object[0]);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
    }

    private List<TerminalVo> convertEntityToVo(List<Terminal> terminalList) {
        Set customerOrgCodeSet;
        List<Object> re = Lists.newArrayList();
        List<String> terminalCodeList = terminalList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return re;
        }
        List<TerminalRelaOrg> terminalRelaOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodeList);
        List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgList = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodeList);
        Set orgCodeSet = terminalRelaOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrg::getOrgCode).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orgCodeSet)) {
            List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodeSet));
            orgVoList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgVoList) ? Lists.newLinkedList() : orgVoList;
            Map<String, String> map = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getOrgName()})).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
            terminalRelaOrgList.forEach(a -> a.setOrgName((String)map.get(a.getOrgCode())));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerOrgCodeSet = terminalRelaCustomerOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaCustomerOrg::getOrgCode).collect(Collectors.toSet()))) {
            List customerOrgVoList = this.customerOrgVoSdkService.findListByCodes((List)Lists.newArrayList(customerOrgCodeSet));
            customerOrgVoList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerOrgVoList) ? Lists.newLinkedList() : customerOrgVoList;
            Map<String, String> map = customerOrgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerOrgCode(), a.getCustomerOrgName()})).collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, CustomerOrgVo::getCustomerOrgName, (a, b) -> a));
            terminalRelaCustomerOrgList.forEach(a -> a.setOrgName((String)map.get(a.getOrgCode())));
        }
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        List terminalSupplyVoList = this.terminalSupplyVoService.findByTerminalCodes(terminalCodeList);
        List<TerminalCustomerVo> terminalCustomerVos = this.terminalCustomerVoService.findByTerminalCodes(terminalCodeList);
        List<TerminalSignAccountVo> accountVos = this.terminalSignAccountVoService.findByTerminalCodes(terminalCodeList);
        re = this.buildTerminalVoList(terminalList, terminalRelaOrgList, terminalRelaCustomerOrgList, terminalContactList, terminalSupplyVoList, terminalCustomerVos, accountVos);
        return re;
    }

    private String commitProcess(TerminalDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        String processKey = processBusiness.getProcessKey();
        if (StringUtils.isBlank((CharSequence)processKey)) {
            processBusiness.setProcessKey(this.defaultProcessKey);
        }
        processBusiness.setProcessTitle(TERMINAL_PROCESS_NAME);
        processBusiness.setBusinessNo(dto.getTerminalCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("terminal_create");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        return processBusinessVo.getProcessNo();
    }

    public List<TerminalVo> findListByRegionRetailerCityCodes(TerminalRegionRetailerCityDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TerminalRegionRetailerCityDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode()) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getRegionCodeList()) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getRetailerCodeList()) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getCityNameList())) {
            return Lists.newArrayList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.terminalRepository.findListByRegionRetailerCityCodes(dto);
    }

    public Page<TerminalVo> findBaseByDto(Pageable pageable, TerminalPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.terminalRepository.findBaseByDto((Page<TerminalVo>)page, dto);
    }

    public Boolean validateCustomerAndTerminal(String terminalCode, String customerCode, CustomerTerminalValidateDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            return false;
        }
        boolean rst = false;
        TerminalCustomer customer = this.terminalCustomerService.findValidByTerminalCodeAndCustomerCode(terminalCode, customerCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerTerminalLevels())) {
            rst = dto.getCustomerTerminalLevels().contains(customer.getCustomerTerminalLevel());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerTerminalTypeCodes())) {
            rst = dto.getCustomerTerminalTypeCodes().contains(customer.getCustomerTerminalSecondTypeCode());
        }
        return rst;
    }

    public Page<TerminalVo> findTerminalDistanceByTerminalQueryDto(TerminalDistanceQueryDto dto) {
        List dictList = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        Optional<DictDataVo> optional = dictList.stream().filter(f -> BusinessFormatEnum.NORMAL.getDesc().equals(f.getDictValue())).findFirst();
        if (optional.isPresent()) {
            dto.setFormatCode(optional.get().getDictCode());
        }
        return this.terminalRepository.findTerminalDistanceByTerminalQueryDto(dto);
    }

    public List<CustomerTerminalVo> getCustomerTerminalList(List<CustomerTerminalQueryDto> dto) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dto)) {
            return new ArrayList<CustomerTerminalVo>();
        }
        List<Terminal> terminals = this.terminalService.findByTerminalCodes(dto.stream().map(CustomerTerminalQueryDto::getTerminalCode).distinct().collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminals)) {
            return new ArrayList<CustomerTerminalVo>();
        }
        return terminals.stream().map(s -> {
            TerminalCustomer terminalCustomer;
            CustomerTerminalVo vo = new CustomerTerminalVo();
            vo.setTerminalCode(s.getTerminalCode());
            vo.setMasterName(s.getMasterName());
            vo.setMasterPhone(s.getMasterPhone());
            vo.setTerminalName(s.getTerminalName());
            Optional<CustomerTerminalQueryDto> first = dto.stream().filter(m -> StringUtils.equals((CharSequence)m.getTerminalCode(), (CharSequence)s.getTerminalCode())).findFirst();
            if (first.isPresent() && ObjectUtils.isNotEmpty((Object)((Object)(terminalCustomer = this.terminalCustomerService.findValidByTerminalCodeAndCustomerCode(s.getTerminalCode(), first.get().getCustomerCode()))))) {
                vo.setCustomerCode(terminalCustomer.getCustomerCode());
                vo.setCustomerTerminalLevel(terminalCustomer.getCustomerTerminalLevel());
                vo.setCustomerTerminalType(terminalCustomer.getCustomerTerminalSecondTypeCode());
                vo.setCustomerType(terminalCustomer.getCustomerType());
                vo.setCustomerTerminalTypeName(terminalCustomer.getCustomerTerminalSecondTypeName());
            }
            return vo;
        }).collect(Collectors.toList());
    }
}

