package com.biz.crm.mdm.business.terminal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalClientDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalClientVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalClientVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 终端客户vo http相关接口
 *
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/terminal/terminalClientVo")
@Api(tags = "终端信息: CustomerClientVo: 终端客户vo")
public class TerminalClientVoController {

  @Autowired(required = false)
  private TerminalClientVoService terminalClientVoService;

  /**
   * 查询当前用户及其下属所关联的终端信息分页列表
   * <p>
   * 用户账号和租户必传
   *
   * @param dto      查询对象
   * @param pageable 分页信息
   * @return Page<TerminalClientVo> 查询当前用户及其下属所关联的终端信息分页列表
   */
  @ApiOperation(value = "查询当前用户及其下属所关联的终端信息分页列表")
  @GetMapping("/findChildrenPageByTerminalClientDto")
  public Result<Page<TerminalClientVo>> findChildrenPageByTerminalClientDto(@PageableDefault(50) Pageable pageable,
                                                                            @ApiParam(name = "TerminalClientDto", value = "分页Dto") TerminalClientDto dto) {
    try {
      return Result.ok(terminalClientVoService.findChildrenPageByTerminalClientDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
