package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaCustomerOrgService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindCustomerOrgDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/4
 */
@Slf4j
@Api(tags = "终端管理: TerminalROrg: 终端关联客户组织")
@RestController
@RequestMapping(value = {"/v1/terminal/terminalRelaCustomerOrg"})
public class TerminalRelaCustomerOrgController {

  @Autowired(required = false) private TerminalRelaCustomerOrgService terminalRelaCustomerOrgService;

  @ApiOperation(value = "更换组织")
  @PatchMapping(value = {"/rebindOrg"})
  public Result<?> rebindOrg(@RequestBody TerminalRebindCustomerOrgDto dto) {
    try {
      this.terminalRelaCustomerOrgService.rebindOrg(dto);
      return Result.ok("更换客户组织成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
