package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalBindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalUnbindSupplyDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 关联终端:
 *
 * <p>1、企业用户关联终端
 *
 * <p>2、客户关联终端
 *
 * <p>3、客户用户关联终端
 *
 * @author sunx
 * @date 2021/11/3
 */
@Slf4j
@Api(tags = "终端管理: TerminalSupply: 供货关系")
@RestController
@RequestMapping(value = {"/v1/terminal/terminalSupply"})
public class TerminalSupplyController {

  @Autowired(required = false) private TerminalSupplyService terminalSupplyService;

  /**
   * 供货关系绑定
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "供货关系绑定")
  @PatchMapping(value = {"/bind"})
  public Result<?> bind(@RequestBody TerminalBindSupplyDto dto) {
    try {
      this.terminalSupplyService.bind(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 解除用户绑定关系
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "解除用户绑定关系")
  @PatchMapping(value = {"/unbind"})
  public Result<?> unbind(@RequestBody TerminalUnbindSupplyDto dto) {
    try {
      this.terminalSupplyService.unbind(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 替换用户绑定关系
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "替换用户绑定关系")
  @PatchMapping(value = {"/rebind"})
  public Result<?> rebind(@RequestBody TerminalRebindSupplyDto dto) {
    try {
      this.terminalSupplyService.rebind(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据客户信息解除绑定关系
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "根据客户信息解除绑定关系")
  @PatchMapping(value = {"/unbindByCustomer"})
  public Result<?> unbindByCustomer(@RequestBody TerminalUnbindSupplyDto dto) {
    try {
      this.terminalSupplyService.unbindByCustomer(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据客户信息替换供货绑定关系
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "根据客户信息替换供货绑定关系")
  @PatchMapping(value = {"/rebindByCustomer"})
  public Result<?> rebindByCustomer(@RequestBody TerminalRebindSupplyDto dto) {
    try {
      this.terminalSupplyService.rebindByCustomer(dto);
      return Result.ok("操作成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
