package com.biz.crm.mdm.business.terminal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.LoginFromTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 终端信息(Terminal)实体类
 *
 * @author sunx
 * @since 2021-10-18 18:10:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_terminal")
@Table(
    name = "mdm_terminal",
    indexes = {
        @Index(name = "mdm_terminal_index0", columnList = "tenant_code,terminal_code", unique = true),
        @Index(name = "mdm_terminal_index3", columnList = "terminal_type"),
        @Index(name = "mdm_terminal_force_index4", columnList = "del_flag, tenant_code, create_time")
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal", comment = "终端信息")
@ApiModel(value = "Terminal", description = "终端信息")
public class Terminal extends WorkflowFlagOpEntity {
  private static final long serialVersionUID = -9188342911877957219L;

  @ApiModelProperty("高德地图ID")
  @TableField(value = "amap_id")
  @Column(name = "amap_id", length = 64, columnDefinition = "varchar(64) COMMENT '高德地图ID'")
  private String amapId;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", length = 64, columnDefinition = "varchar(64) COMMENT '终端名称'")
  private String terminalName;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  @TableField(value = "terminal_type")
  @Column(name = "terminal_type", length = 64, columnDefinition = "varchar(64) COMMENT '终端类型'")
  private String terminalType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '所属组织编码'")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  @TableField(exist = false)
  @Transient
  private String orgName;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  @TableField(value = "customer_org_code")
  @Column(
      name = "customer_org_code",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '客户组织编码'")
  private String customerOrgCode;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  @TableField(value = "channel")
  @Column(name = "channel", length = 255, columnDefinition = "varchar(255) COMMENT '渠道'")
  private String channel;

  /**
   * 营业执照人名称
   */
  @ApiModelProperty("营业执照人名称")
  @TableField(value = "license_person_name")
  @Column(
      name = "license_person_name",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照人名称'")
  private String licensePersonName;

  /**
   * 营业执照注册号
   */
  @ApiModelProperty("营业执照注册号")
  @TableField(value = "license_register_number")
  @Column(
      name = "license_register_number",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照注册号'")
  private String licenseRegisterNumber;

  /**
   * 营业执照企业名称
   */
  @ApiModelProperty("营业执照企业名称")
  @TableField(value = "license_firm_name")
  @Column(
      name = "license_firm_name",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照企业名称'")
  private String licenseFirmName;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  @TableField(value = "terminal_address")
  @Column(name = "terminal_address", length = 200, columnDefinition = "varchar(200) COMMENT '终端地址'")
  private String terminalAddress;

  /**
   * 省
   */
  @ApiModelProperty("省")
  @TableField(value = "province_code")
  @Column(name = "province_code", length = 64, columnDefinition = "varchar(64) COMMENT '省'")
  private String provinceCode;

  @ApiModelProperty("省名称")
  @TableField(value = "province_name")
  @Column(name = "province_name", length = 128, columnDefinition = "varchar(128) COMMENT '省名称'")
  private String provinceName;

  /**
   * 市
   */
  @ApiModelProperty("市")
  @TableField(value = "city_code")
  @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市'")
  private String cityCode;

  @ApiModelProperty("市名称")
  @TableField(value = "city_name")
  @Column(name = "city_name", length = 128, columnDefinition = "varchar(128) COMMENT '市名称'")
  private String cityName;

  /**
   * 区
   */
  @ApiModelProperty("区")
  @TableField(value = "district_code")
  @Column(name = "district_code", length = 64, columnDefinition = "varchar(64) COMMENT '区'")
  private String districtCode;

  @ApiModelProperty("区名称")
  @TableField(value = "district_name")
  @Column(name = "district_name", length = 128, columnDefinition = "varchar(128) COMMENT '区名称'")
  private String districtName;

  /**
   * 店招照片
   */
  @ApiModelProperty("店招照片")
  @TableField(value = "shop_image_path")
  @Column(name = "shop_image_path", length = 255, columnDefinition = "varchar(255) COMMENT '店招照片'")
  private String shopImagePath;

  /**
   * 营业执照照片
   */
  @ApiModelProperty("营业执照照片")
  @TableField(value = "license_image_path")
  @Column(
      name = "license_image_path",
      length = 255,
      columnDefinition = "varchar(255) COMMENT '营业执照照片'")
  private String licenseImagePath;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  @TableField(value = "longitude")
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  @TableField(value = "latitude")
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  private BigDecimal latitude;

  /**
   * 客户分类
   */
  @ApiModelProperty("客户分类")
  @TableField(value = "customer_classification")
  @Column(
      name = "customer_classification",
      length = 64,
      columnDefinition = "varchar(64) COMMENT '客户分类'")
  private String customerClassification;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  @TableField(value = "act_approve_status")
  @Column(name = "act_approve_status", length = 64, columnDefinition = "varchar(64) COMMENT '审批状态'")
  private String actApproveStatus;

  /**
   * 合作状态
   */
  @ApiModelProperty("合作状态")
  @TableField(value = "cooperate_status")
  @Column(name = "cooperate_status", length = 30, columnDefinition = "varchar(30) COMMENT '合作状态'")
  private String cooperateStatus;

  /**
   * kms客户关联门店id
   */
  @ApiModelProperty("kms客户关联门店id")
  @TableField(value = "store_id")
  @Column(name = "store_id", length = 64, columnDefinition = "varchar(64) COMMENT 'kms客户关联门店id'")
  private String storeId;

  /**
   * kms直营体系id
   */
  @ApiModelProperty("kms直营体系id")
  @TableField(value = "direct_system_id")
  @Column(
      name = "direct_system_id",
      length = 64,
      columnDefinition = "varchar(64) COMMENT 'kms直营体系id'")
  private String directSystemId;

  /**
   * kms售达方id
   */
  @ApiModelProperty("kms售达方id")
  @TableField(value = "sell_party_id")
  @Column(name = "sell_party_id", length = 64, columnDefinition = "varchar(64) COMMENT 'kms售达方id'")
  private String sellPartyId;

  @ApiModelProperty("审批类型")
  @TableField(value = "approval_type")
  @Column(name = "approval_type", length = 32, columnDefinition = "varchar(32) COMMENT '审批类型'")
  private String approvalType;

  @ApiModelProperty("流程实例编码")
  @TableField(value = "process_code")
  @Column(name = "process_code", length = 64, columnDefinition = "varchar(64) COMMENT '流程实例编码'")
  private String processCode;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  @TableField(value = "source_type")
  @Column(name = "source_type", length = 32, columnDefinition = "varchar(32) COMMENT '数据来源'")
  private String sourceType;

  /**
   * 业务来源系统
   *
   * @see LoginFromTypeEnum#getValue()
   */
  @ApiModelProperty("业务来源系统")
  @TableField(value = "from_type")
  @Column(name = "from_type", length = 32, columnDefinition = "varchar(32) COMMENT '业务来源系统'")
  private String fromType;

  /**
   * 联系人信息
   */
  @TableField(exist = false)
  @Transient
  private List<TerminalContact> contactList;

  /**
   * 客户组织
   */
  @TableField(exist = false)
  @Transient
  private TerminalRelaCustomerOrg customerOrg;

  /**
   * 所属组织
   */
  @TableField(exist = false)
  @Transient
  private TerminalRelaOrg org;

  /**
   * 供货关系
   */
  @TableField(exist = false)
  @Transient
  private List<TerminalSupply> supplyList;

  /**
   * 终端标签
   */
  @TableField(exist = false)
  @Transient
  private List<TerminalTag> tagList;

  /**
   * 终端标签文本逗号隔开
   */
  @TableField(exist = false)
  @Transient
  private String tagStr;
}
