package com.biz.crm.mdm.business.terminal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端与组织关联表(TerminalROrg)实体类
 *
 * @author sunx
 * @since 2021-10-18 18:21:03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_terminal_r_org")
@Table(
    name = "mdm_terminal_r_org",
    indexes = {
      @Index(
          name = "mdm_terminal_r_org_index",
          columnList = "tenant_code,terminal_code,org_code",
          unique = true),
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_r_org", comment = "终端与组织关联表")
@ApiModel(value = "TerminalROrg", description = "终端与组织关联表")
public class TerminalRelaOrg extends TenantEntity {

  private static final long serialVersionUID = -1411224807698958231L;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '组织编码'")
  private String orgCode;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name", length = 64, columnDefinition = "varchar(64) COMMENT '组织名称'")
  private String orgName;
}
