package com.biz.crm.mdm.business.terminal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端标签(TerminalTag)实体类
 *
 * @author sunx
 * @since 2021-11-02 13:48:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_terminal_tag")
@Table(
    name = "mdm_terminal_tag",
    indexes = {
      @Index(name = "mdm_terminal_tag_index1", columnList = "terminal_code"),
      @Index(name = "mdm_terminal_tag_index2", columnList = "tenant_code"),
      @Index(name = "mdm_terminal_tag_index3", columnList = "tag_type")
    })
@ApiModel(value = "TerminalTag", description = "终端标签")
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_tag", comment = "终端标签")
public class TerminalTag extends TenantFlagOpEntity {
  private static final long serialVersionUID = -1642701831123818333L;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '终端编码'")
  private String terminalCode;

  /** 标签类型 */
  @ApiModelProperty("标签类型")
  @TableField(value = "tag_type")
  @Column(name = "tag_type", length = 32, columnDefinition = "varchar(32) COMMENT '标签类型'")
  private String tagType;

  /** 标签描述 */
  @ApiModelProperty("标签描述")
  @TableField(value = "tag_description")
  @Column(name = "tag_description", length = 64, columnDefinition = "varchar(64) COMMENT '标签描述'")
  private String tagDescription;
}
