package com.biz.crm.mdm.business.terminal.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 终端信息(Terminal)表数据库访问层
 *
 * @author sunx
 * @since 2021-10-18 17:46:49
 */
public interface TerminalMapper extends BaseMapper<Terminal> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<Terminal> findByConditions(Page<Terminal> page, @Param("dto") TerminalPaginationDto dto);

  /**
   * 根据企业组织获取对应的终端主信息
   *
   * @param orgCodeList
   * @param tenantCode
   * @return
   */
  List<TerminalRelaOrgVo> findTerminalRelaOrgByOrgCodes(
      @Param("list") List<String> orgCodeList, @Param("tenantCode") String tenantCode);

  /**
   * 根据客户编码查询
   *
   * @param customerOrgCodes
   * @param tenantCode
   * @param delFlag
   * @return
   */
  List<Terminal> findByCustomerOrgCodes(
      @Param("list") List<String> customerOrgCodes,
      @Param("tenantCode") String tenantCode,
      @Param("delFlag") String delFlag);

  /**
   * 根据组织、渠道、标签获取匹配的终端编码
   *
   * @param dto
   * @return
   */
  Set<String> findByTerminalCodeSearchDto(@Param("dto") TerminalCodeSearchDto dto);

  /**
   * 根据组织、渠道、标签获取匹配的终端
   *
   * @param dto 参数dto
   * @return 终端基本信息
   */
  List<Terminal> findByTerminalSearchDto(@Param("dto") TerminalSearchDto dto);

  /**
   * 获取终端编码
   *
   * @param dto
   * @param tenantCode
   * @return
   */
  Set<String> findByTerminalQueryDto(
      @Param("dto") TerminalQueryDto dto, @Param("tenantCode") String tenantCode);
}
