package com.biz.crm.mdm.business.terminal.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 终端业务员(TerminalSupply)表数据库访问层
 *
 * @author sunx
 * @since 2021-10-18 17:49:33
 */
public interface TerminalSupplyMapper extends BaseMapper<TerminalSupply> {

  /**
   * 获取终端关联商品的供货经销商编码-商品
   *
   * @param terminalCode
   * @param customerCodeFlag
   * @param dataType
   * @param productCodeSet
   * @param tenantCode
   * @return
   */
  Set<String> findTerminalSupplyCustomerCodeSetByProduct(
      @Param("terminalCode") String terminalCode,
      @Param("customerCodeFlag") String customerCodeFlag,
      @Param("dataType") String dataType,
      @Param("productCodeSet") Set<String> productCodeSet,
      @Param("tenantCode") String tenantCode);

  /**
   * 获取终端关联商品的供货经销商编码-商品层级
   *
   * @param terminalCode
   * @param customerCodeFlag
   * @param dataType
   * @param productLevelCodeSet
   * @param tenantCode
   * @return
   */
  Set<String> findTerminalSupplyCustomerCodeSetByProductLevel(
      @Param("terminalCode") String terminalCode,
      @Param("customerCodeFlag") String customerCodeFlag,
      @Param("dataType") String dataType,
      @Param("productLevelCodeSet") Set<String> productLevelCodeSet,
      @Param("tenantCode") String tenantCode);

  /**
   * 获取未配置供货商品明细的供货经销商编码信息
   *
   * @param terminalCode
   * @param tenantCode
   * @return
   */
  Set<String> findTerminalSupplyCustomerCodeSetByNoProduct(
      @Param("terminalCode") String terminalCode, @Param("tenantCode") String tenantCode);
}
