package com.biz.crm.mdm.business.terminal.local.observer;

import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.sdk.constant.TerminalConstant;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalEventDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 终端审批回调类
 *
 * 弃用（现用：ProcessCompleteListenerOfTerminal）
 * @author jerry7
 */
@Deprecated
@Component
public class TerminalCallbackListener implements CallBackListener {

  @Autowired(required = false) private TerminalService terminalService;

  @Autowired(required = false) private NebulaNetEventClient nebulaNetEventClient;

  @Autowired(required = false) private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false) private TerminalRelaOrgService terminalRelaOrgService;

  @Override
  @Transactional
  public void onCallBack(CallBackDto dto) {
    if (!dto.getFormType().equals(TerminalConstant.TERMINAL_PROCESS_NAME)) {
      return;
    }
    // 校验单号(查询方法缺失)
    final Terminal terminal = this.terminalService.findByProcessNumber(dto.getProcessNo());
    Validate.notNull(terminal, "终端信息不存在");
    // 校验审批状态
    Validate.isTrue(
        ActApproveStatusEnum.APPROVING.getCode().equals(terminal.getProcessStatus()),
        "终端非审批中状态，无法进行操作！");
    // 根据回调类别处理对应业务
    if (StringUtils.equals(
        String.valueOf(dto.getProcessState()), ActApproveStatusEnum.APPROVED.getCode())) {
      // 审批通过业务处理
      terminal.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
    } else if (StringUtils.equals(
        String.valueOf(dto.getProcessState()), ActApproveStatusEnum.REJECTED.getCode())) {
      // 审批驳回业务处理
      terminal.setProcessStatus(ActApproveStatusEnum.REJECTED.getCode());
    } else if (StringUtils.equals(
        String.valueOf(dto.getProcessState()), ActApproveStatusEnum.INTERRUPT.getCode())) {
      // 流程追回业务处理
      terminal.setProcessStatus(ActApproveStatusEnum.INTERRUPT.getCode());
    }
    this.terminalService.updateByProcess(terminal);
    if (terminal.getProcessStatus().equals(ActApproveStatusEnum.APPROVED.getCode())) {
      final List<TerminalRelaOrg> orgList =
          this.terminalRelaOrgService.findByTerminalCodes(
              Lists.newArrayList(terminal.getTerminalCode()));

      TerminalVo vo =
          this.nebulaToolkitService.copyObjectByBlankList(
              terminal, TerminalVo.class, HashSet.class, ArrayList.class);
      if (CollectionUtils.isNotEmpty(orgList)) {
        List<TerminalRelaOrgVo> orgVoList =
            (List<TerminalRelaOrgVo>)
                this.nebulaToolkitService.copyCollectionByBlankList(
                    orgList,
                    TerminalRelaOrg.class,
                    TerminalRelaOrgVo.class,
                    HashSet.class,
                    ArrayList.class);
        vo.setOrgList(orgVoList);
      }
      TerminalEventDto eventDto = new TerminalEventDto();
      eventDto.setOriginal(null);
      eventDto.setNewest(vo);
      // 终端审批通过创建事件
      SerializableBiConsumer<TerminalEventListener, TerminalEventDto> onApproved =
          TerminalEventListener::onApproved;
      this.nebulaNetEventClient.publish(eventDto, TerminalEventListener.class, onApproved);
    }
    // ---------------  end -------------------
  }
}
