package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupplyDetail;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalSupplyDetailMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 门店供货关系明细(repository)
 *
 * @author sunx
 * @since 2021-10-18 17:50:15
 */
@Component
public class TerminalSupplyDetailRepository extends
    ServiceImpl<TerminalSupplyDetailMapper, TerminalSupplyDetail> {

  public List<TerminalSupplyDetail> findBySupplyIds(List<String> supplyIdList) {
    return this.lambdaQuery().eq(TerminalSupplyDetail::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalSupplyDetail::getSupplyId, supplyIdList).list();
  }

  public void deleteBySupplyIds(List<String> supplyIdList) {
    LambdaQueryWrapper<TerminalSupplyDetail> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(TerminalSupplyDetail::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalSupplyDetail::getSupplyId, supplyIdList);
    baseMapper.delete(lambdaQuery);
  }
}
