package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.customer.org.sdk.event.CustomerOrgEventListener;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe:客户组织时间监听实现
 * @createTime 2022年02月17日 09:42:00
 */
@Component
public class CustomerOrgEventListenerImpl implements CustomerOrgEventListener {

  @Autowired(required = false)
  private TerminalService terminalService;

  @Override
  public void onBatchCreate(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  @Override
  public void onBatchUpdate(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  /**
   * 当客户组织发生删除事件时，根据触发事件的客户组织编码,验证客户组织是否存在与终端的关联关系。
   * <p>
   * 1.存在与终端的关联关系,则抛出组织已关联终端的异常,阻断当前客户组织的删除操作
   * 2.不存在与终端的关联关系,则什么也不做.
   */
  @Override
  public void onBatchDelete(List<CustomerOrgVo> customerOrgVos) {
    if (CollectionUtils.isEmpty(customerOrgVos)) {
      return;
    }
    List<String> customerOrgCodes = customerOrgVos.stream().map(CustomerOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(customerOrgCodes)) {
      return;
    }
    List<Terminal> byCustomerOrgCodes = terminalService.findByCustomerOrgCodes(customerOrgCodes);
    Validate.isTrue(CollectionUtils.isEmpty(byCustomerOrgCodes), "该客户组织与终端存在绑定关系，无法删除");
  }

  @Override
  public void onBatchEnable(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  @Override
  public void onBatchDisable(List<CustomerOrgVo> eventDtos) {
    //do nothing
  }
}
