package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 职位信息变更事件通知接口实现
 *
 * @author sunx
 * @date 2022/3/17
 */
@Component("terminalPositionEventListenerImpl")
public class PositionEventListenerImpl implements PositionEventListener {
  @Autowired(required = false) private TerminalSupplyService terminalSupplyService;
  @Autowired(required = false) private TerminalService terminalService;

  @Override
  public void onCreate(PositionEventVo vo) {}

  @Override
  public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {}

  @Override
  public void onDisable(List<PositionEventVo> voList) {}

  @Override
  public void onEnable(List<PositionEventVo> voList) {}

  @Override
  public void onDelete(List<PositionEventVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    Set<String> positionCodeSet =
        voList.stream()
            .filter(a -> StringUtils.isNotBlank(a.getPositionCode()))
            .map(PositionEventVo::getPositionCode)
            .collect(Collectors.toSet());
    if (CollectionUtils.isEmpty(positionCodeSet)) {
      return;
    }
    List<TerminalSupply> supplyList =
        this.terminalSupplyService.findByPositionCodes(positionCodeSet);
    if (CollectionUtils.isEmpty(supplyList)) {
      return;
    }
    List<String> terminalCodes =
        supplyList.stream().map(TerminalSupply::getTerminalCode).collect(Collectors.toList());
    List<Terminal> terminalList = this.terminalService.findByTerminalCodes(terminalCodes);
    Validate.isTrue(CollectionUtils.isEmpty(terminalList), "该客户与终端存在供货关系信息，无法删除!");
  }

  @Override
  public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
    return null;
  }
}
