package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe: 客户用户事件监听器
 * @createTime 2022年01月11日 15:07:00
 */
@Component
public class TerminalCustomerEventListenerImpl implements CustomerEventListener {

  @Autowired(required = false) private TerminalSupplyService terminalSupplyService;
  @Autowired(required = false) private TerminalService terminalService;

  /**
   * 当客户信息删除时触发
   *
   * @param dto
   */
  @Override
  public void onDelete(CustomerEventDto dto) {
    Validate.notNull(dto, "客户信息不能为空");
    Validate.notNull(dto.getOriginal(), "客户信息不能为空");
    List<TerminalSupply> supplyList =
        this.terminalSupplyService.findByCustomerCodes(
            Sets.newHashSet(dto.getOriginal().getCustomerCode()));
    if (CollectionUtils.isEmpty(supplyList)) {
      return;
    }
    List<String> terminalCodes =
        supplyList.stream().map(TerminalSupply::getTerminalCode).collect(Collectors.toList());
    List<Terminal> terminalList = this.terminalService.findByTerminalCodes(terminalCodes);
    Validate.isTrue(CollectionUtils.isEmpty(terminalList), "该客户与终端存在供货关系信息，无法删除!");
  }
}
