/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalRelaOrgMapper;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class TerminalRelaOrgRepository
extends ServiceImpl<TerminalRelaOrgMapper, TerminalRelaOrg> {
    private static final Integer SIZE = 1000;

    public List<TerminalRelaOrg> findByTerminalCodes(List<String> terminalCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalRelaOrg::getTerminalCode, terminalCodeList)).list();
    }

    public void deleteByTerminalCodes(List<String> terminalCodeList) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalRelaOrg::getTerminalCode, terminalCodeList);
        ((TerminalRelaOrgMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public void deleteByOrgCodesAndTerminalCodes(List<String> orgCodeList, List<String> terminalCodeList) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalRelaOrg::getOrgCode, orgCodeList)).in(TerminalRelaOrg::getTerminalCode, terminalCodeList);
        ((TerminalRelaOrgMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public List<TerminalRelaOrg> findByOrgCodes(List<String> orgCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalRelaOrg::getOrgCode, orgCodes)).list();
    }

    public List<TerminalRelaOrg> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
        ArrayList list = Lists.newArrayList();
        String processStatus = ProcessStatusEnum.PASS.getDictCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        String tenantCode = TenantUtils.getTenantCode();
        for (List item : Lists.partition((List)Lists.newArrayList(orgCodes), (int)SIZE)) {
            List<TerminalRelaOrg> cur = ((TerminalRelaOrgMapper)this.baseMapper).findAllowSaleTerminalByOrgCodes(item, processStatus, delFlag, tenantCode);
            if (CollectionUtils.isEmpty(cur)) continue;
            list.addAll(cur);
        }
        return list;
    }
}

