/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRelaOrgRepository;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelateOrgEventDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalRelateOrgEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalRelaOrgService")
public class TerminalRelaOrgServiceImpl
implements TerminalRelaOrgService {
    @Autowired(required=false)
    private TerminalRelaOrgRepository terminalRelaOrgRepository;
    @Autowired(required=false)
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private static volatile Cache<String, List<TerminalRelaOrg>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalRelaOrgServiceImpl() {
        if (cache != null) return;
        Class<TerminalRelaOrgServiceImpl> clazz = TerminalRelaOrgServiceImpl.class;
        synchronized (TerminalRelaOrgServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<TerminalRelaOrg> findByTerminalCodes(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), terminalCodeList});
        List<TerminalRelaOrg> records = (List<TerminalRelaOrg>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRelaOrgRepository.findByTerminalCodes(terminalCodeList);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    @Transactional
    public void saveBatch(List<TerminalRelaOrg> list, String terminalCode) {
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRelaOrgRepository.deleteByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<TerminalRelaOrg> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getTerminalCode()) || StringUtils.isBlank((CharSequence)a.getOrgCode()) || !terminalCode.equals(a.getTerminalCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u6216\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u7ec8\u7aef", (Object[])new Object[0]);
        Map<String, List<TerminalRelaOrg>> map = list.stream().collect(Collectors.groupingBy(TerminalRelaOrg::getOrgCode));
        map.entrySet().forEach(a -> Validate.isTrue((((List)a.getValue()).size() <= 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u7ec7\u4fe1\u606f", (Object[])new Object[0]));
        for (TerminalRelaOrg terminalRelaOrg : list) {
            terminalRelaOrg.setId(null);
            terminalRelaOrg.setTenantCode(TenantUtils.getTenantCode());
        }
        this.terminalRelaOrgRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void rebindOrg(TerminalRebindOrgDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getNewOrgCode(), (String)"\u66f4\u6362\u540e\u7684\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodeList()), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList deleteOrgCodeList = Lists.newArrayList((Object[])new String[]{dto.getNewOrgCode()});
        if (StringUtils.isNotBlank((CharSequence)dto.getOldOrgCode())) {
            deleteOrgCodeList.add(dto.getOldOrgCode());
        }
        this.terminalRelaOrgRepository.deleteByOrgCodesAndTerminalCodes(deleteOrgCodeList, dto.getTerminalCodeList());
        LinkedList list = Lists.newLinkedList();
        LinkedHashSet set = Sets.newLinkedHashSet((Iterable)dto.getTerminalCodeList());
        for (String terminalCode : set) {
            TerminalRelaOrg cur = new TerminalRelaOrg();
            cur.setId(null);
            cur.setTenantCode(TenantUtils.getTenantCode());
            cur.setTerminalCode(terminalCode);
            cur.setOrgCode(dto.getNewOrgCode());
            list.add(cur);
        }
        this.terminalRelaOrgRepository.saveBatch(list);
        List<Terminal> terminalList = this.terminalRepository.findByTerminalCodes(dto.getTerminalCodeList());
        if (CollectionUtils.isEmpty(terminalList)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo item : voList) {
            TerminalRelateOrgEventDto eventDto = new TerminalRelateOrgEventDto();
            eventDto.setOldOrgCode(dto.getOldOrgCode());
            eventDto.setNewOrgCode(dto.getNewOrgCode());
            eventDto.setTerminalVo(item);
            SerializableBiConsumer & Serializable onRebind = TerminalRelateOrgEventListener::onRebind;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalRelateOrgEventListener.class, (SerializableBiConsumer)onRebind);
        }
    }

    @Override
    public List<TerminalRelaOrg> findByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), orgCodes});
        List<TerminalRelaOrg> records = (List<TerminalRelaOrg>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRelaOrgRepository.findByOrgCodes(orgCodes);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public void deleteByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        this.terminalRelaOrgRepository.deleteByTerminalCodes(terminalCodes);
    }

    @Override
    @Transactional
    public void create(String orgCode, String terminalCode, String tenantCode) {
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRelaOrgRepository.deleteByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return;
        }
        TerminalRelaOrg terminalRelaOrg = new TerminalRelaOrg();
        terminalRelaOrg.setTerminalCode(terminalCode);
        terminalRelaOrg.setOrgCode(orgCode);
        terminalRelaOrg.setTenantCode(tenantCode);
        this.terminalRelaOrgRepository.save((Object)terminalRelaOrg);
    }
}

