/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaCustomerOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalTag;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaCustomerOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalTagService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalEventDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalEventListener;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.strategy.CompletedCountStrategy;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalService")
public class TerminalServiceImpl
implements TerminalService {
    @Autowired(required=false)
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TerminalRelaCustomerOrgService terminalRelaCustomerOrgService;
    @Autowired(required=false)
    private TerminalRelaOrgService terminalRelaOrgService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TerminalContactService terminalContactService;
    @Autowired(required=false)
    private TerminalSupplyVoService terminalSupplyVoService;
    @Autowired(required=false)
    private TerminalTagService terminalTagService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private List<CompletedCountStrategy> completedCountStrategies;
    private static volatile Cache<String, List<Terminal>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalServiceImpl() {
        if (cache != null) return;
        Class<TerminalServiceImpl> clazz = TerminalServiceImpl.class;
        synchronized (TerminalServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Page<Terminal> findByConditions(Pageable pageable, TerminalPaginationDto dto) {
        String cacheKey;
        List records;
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Terminal> byConditions = new Page<Terminal>();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)dto.getTenantCode())) {
            sb.append(dto.getTenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDelFlag())) {
            sb.append(dto.getDelFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEnableStatus())) {
            sb.append(dto.getEnableStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProcessStatus())) {
            sb.append(dto.getProcessStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
            sb.append(dto.getOrgCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerOrgCode())) {
            sb.append(dto.getCustomerOrgCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalType())) {
            sb.append(dto.getTerminalType());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalCode())) {
            sb.append(dto.getTerminalCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalName())) {
            sb.append(dto.getTerminalName());
        }
        if ((records = (List)cache.getIfPresent((Object)(cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), sb.toString()})))) == null) {
            byConditions = this.terminalRepository.findByConditions((Page<Terminal>)page, dto);
            if (CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
                return byConditions;
            }
            records = byConditions.getRecords();
            cache.put((Object)cacheKey, (Object)records);
        }
        List orgCodes = records.stream().map(Terminal::getOrgCode).collect(Collectors.toList());
        List orgVos = this.orgVoService.findByOrgCodes(orgCodes);
        List<String> terminalCodes = records.stream().map(Terminal::getTerminalCode).collect(Collectors.toList());
        List<TerminalRelaCustomerOrg> customerOrgList = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodes);
        List<TerminalRelaOrg> orgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodes);
        List<TerminalTag> terminalTagList = this.terminalTagService.findByTerminalCodes(Sets.newHashSet(terminalCodes));
        Map<Object, Object> customerOrgMap = Maps.newHashMap();
        Map<Object, Object> orgMap = Maps.newHashMap();
        Map<Object, Object> tagMap = Maps.newHashMap();
        Map orgVoMap = Optional.ofNullable(orgVos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        if (CollectionUtils.isNotEmpty(customerOrgList)) {
            customerOrgMap = customerOrgList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getTerminalCode())).collect(Collectors.toMap(TerminalRelaCustomerOrg::getTerminalCode, v -> v, (a, b) -> a));
        }
        if (CollectionUtils.isNotEmpty(orgList)) {
            orgMap = orgList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getTerminalCode())).collect(Collectors.toMap(TerminalRelaOrg::getTerminalCode, v -> v, (a, b) -> a));
        }
        if (CollectionUtils.isNotEmpty(terminalTagList)) {
            tagMap = terminalTagList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).collect(Collectors.groupingBy(TerminalTag::getTerminalCode));
        }
        List<TerminalContact> terminalContacts = this.terminalContactService.findByTerminalCodes(terminalCodes);
        Map<Object, Object> listMap = new HashMap();
        if (!CollectionUtils.isEmpty(terminalContacts)) {
            listMap = terminalContacts.stream().collect(Collectors.groupingBy(TerminalContact::getTerminalCode));
        }
        for (Terminal terminal : records) {
            OrgVo orgVo = (OrgVo)orgVoMap.get(terminal.getOrgCode());
            if (orgVo != null) {
                terminal.setOrgName(orgVo.getOrgName());
            }
            if (customerOrgMap.containsKey(terminal.getTerminalCode())) {
                terminal.setCustomerOrg((TerminalRelaCustomerOrg)((Object)customerOrgMap.get(terminal.getTerminalCode())));
            }
            if (orgMap.containsKey(terminal.getTerminalCode())) {
                terminal.setOrg((TerminalRelaOrg)((Object)orgMap.get(terminal.getTerminalCode())));
            }
            terminal.setTagList((List)tagMap.get(terminal.getTerminalCode()));
            if (CollectionUtils.isNotEmpty(terminal.getTagList())) {
                terminal.setTagStr(terminal.getTagList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTagDescription())).map(TerminalTag::getTagDescription).collect(Collectors.joining(",")));
            }
            terminal.setContactList((List)listMap.get(terminal.getTerminalCode()));
        }
        return byConditions;
    }

    @Override
    public Terminal findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.terminalRepository.findById(id);
    }

    @Override
    @Transactional
    public Terminal create(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminal.getTerminalName()), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)terminal.getTerminalCode())) {
            terminal.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(terminal.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(terminal.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        terminal.setTenantCode(TenantUtils.getTenantCode());
        terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        terminal.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.terminalRepository.saveOrUpdate((Object)terminal);
        TerminalVo vo = (TerminalVo)this.nebulaToolkitService.copyObjectByBlankList((Object)terminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        TerminalEventDto eventDto = new TerminalEventDto();
        eventDto.setOriginal(null);
        eventDto.setNewest(vo);
        SerializableBiConsumer & Serializable onCreate = TerminalEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onCreate);
        return terminal;
    }

    @Override
    @Transactional
    public Terminal update(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminal.getId()), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String currentId = terminal.getId();
        Terminal current = this.terminalRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)terminal.getTerminalCode().equals(current.getTerminalCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.terminalRepository.saveOrUpdate((Object)terminal);
        TerminalVo vo1 = (TerminalVo)this.nebulaToolkitService.copyObjectByBlankList((Object)current, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        TerminalVo vo2 = (TerminalVo)this.nebulaToolkitService.copyObjectByBlankList((Object)terminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<TerminalRelaOrgVo>> map = this.findTerminalOrgMap(Lists.newArrayList((Object[])new Terminal[]{current}));
        vo2.setOrgList(map.get(terminal.getTerminalCode()));
        TerminalEventDto eventDto = new TerminalEventDto();
        eventDto.setOriginal(vo1);
        eventDto.setNewest(vo2);
        SerializableBiConsumer & Serializable onUpdate = TerminalEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onUpdate);
        return terminal;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        List<Terminal> list = this.terminalRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<TerminalRelaOrgVo>> map = this.findTerminalOrgMap(list);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo vo : voList) {
            TerminalEventDto eventDto = new TerminalEventDto();
            vo.setOrgList(map.get(vo.getTerminalCode()));
            eventDto.setNewest(vo);
            SerializableBiConsumer & Serializable onEnable = TerminalEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        List<Terminal> list = this.terminalRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo vo : voList) {
            TerminalEventDto eventDto = new TerminalEventDto();
            eventDto.setNewest(vo);
            SerializableBiConsumer & Serializable onDisable = TerminalEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        List<TerminalRelaOrg> terminalOrgList;
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Terminal> terminalList = this.terminalRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(terminalList)) {
            return;
        }
        this.terminalRepository.updateDelFlagByIds(ids);
        List<String> terminalCodes = terminalList.stream().filter(terminal -> StringUtils.isNotBlank((CharSequence)terminal.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(terminalCodes) && CollectionUtils.isNotEmpty(terminalOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodes))) {
            map = terminalOrgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()})).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toSet())));
        }
        this.deleteExtInfo(terminalCodes);
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo vo : voList) {
            Set curSet = (Set)map.get(vo.getTerminalCode());
            if (CollectionUtils.isNotEmpty((Collection)curSet)) {
                LinkedList curOrgList = Lists.newLinkedList();
                for (String orgCode : curSet) {
                    TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
                    cur.setOrgCode(orgCode);
                    curOrgList.add(cur);
                }
                vo.setOrgList((List)curOrgList);
            }
            TerminalEventDto eventDto = new TerminalEventDto();
            eventDto.setOriginal(vo);
            SerializableBiConsumer & Serializable onDelete = TerminalEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    public List<Terminal> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(terminalCodes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), ids, terminalCodes});
        List<Terminal> records = (List<Terminal>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRepository.findDetailsByIdsOrTerminalCodes(ids, terminalCodes);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public List<Terminal> findByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return new ArrayList<Terminal>(0);
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), terminalCodes});
        List<Terminal> records = (List<Terminal>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRepository.findByTerminalCodes(terminalCodes);
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public List<Terminal> findByCustomerOrgCodes(List<String> customerOrgCodes) {
        if (CollectionUtils.isEmpty(customerOrgCodes)) {
            return new ArrayList<Terminal>(0);
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), customerOrgCodes});
        List<Terminal> records = (List<Terminal>)cache.getIfPresent((Object)cacheKey);
        if (records == null) {
            records = this.terminalRepository.findByCustomerOrgCodes(customerOrgCodes, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL.getCode());
            cache.put((Object)cacheKey, records);
        }
        return records;
    }

    @Override
    public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        if (CollectionUtils.isEmpty((Collection)(dto = Optional.ofNullable(dto).orElse(new TerminalCodeSearchDto())).getOrgCodeSet()) && CollectionUtils.isEmpty((Collection)dto.getChannelSet()) && CollectionUtils.isEmpty((Collection)dto.getTagSet())) {
            return Sets.newHashSet();
        }
        return this.terminalRepository.findByTerminalCodeSearchDto(dto);
    }

    @Override
    public Terminal findByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        List<Terminal> list = this.terminalRepository.findByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Terminal findByProcessNumber(String processNumber) {
        if (StringUtils.isBlank((CharSequence)processNumber)) {
            return null;
        }
        return this.terminalRepository.findByProcessNumber(processNumber);
    }

    @Override
    @Transactional
    public void updateByProcess(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getId(), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getProcessStatus(), (String)"\u7ec8\u7aef\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRepository.updateById((Object)terminal);
    }

    @Override
    public Map<String, Integer> findCountByCreateAccountAndDateTypeAndFromType(String createAccount, String dateType, String fromType) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fromType, dateType})) {
            return new HashMap<String, Integer>(0);
        }
        if (StringUtils.isBlank((CharSequence)createAccount)) {
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            createAccount = loginDetails.getAccount();
        }
        if (CollectionUtils.isEmpty(this.completedCountStrategies)) {
            return new HashMap<String, Integer>(0);
        }
        for (CompletedCountStrategy completedCountStrategy : this.completedCountStrategies) {
            if (!completedCountStrategy.dateType().equals(dateType)) continue;
            return completedCountStrategy.findCountByCreateAccountAndFromType(createAccount, fromType);
        }
        return null;
    }

    private void deleteExtInfo(List<String> terminalCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(terminalCodes) ? 1 : 0) != 0, (String)"\u5220\u9664\u5173\u8054\u4fe1\u606f\u65f6\u7f3a\u5931\u7f16\u7801", (Object[])new Object[0]);
        this.terminalRelaOrgService.deleteByTerminalCodes(terminalCodes);
        this.terminalRelaCustomerOrgService.deleteByTerminalCodes(terminalCodes);
        this.terminalContactService.deleteByTerminalCodes(terminalCodes);
        this.terminalSupplyVoService.deleteByTerminalCodes(terminalCodes);
    }

    private Map<String, List<TerminalRelaOrgVo>> findTerminalOrgMap(List<Terminal> list) {
        List<TerminalRelaOrg> orgList;
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<Object, Object> map = Maps.newHashMap();
        Set terminalCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(terminalCodeSet) && CollectionUtils.isNotEmpty(orgList = this.terminalRelaOrgService.findByTerminalCodes(Lists.newArrayList(terminalCodeSet)))) {
            List orgVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(orgList, TerminalRelaOrg.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            map = orgVoList.stream().collect(Collectors.groupingBy(TerminalRelaOrgVo::getTerminalCode));
        }
        return map;
    }
}

