/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalSupplyMapper;
import com.biz.crm.mdm.business.terminal.sdk.enums.TerminalSupplyTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class TerminalSupplyRepository
extends ServiceImpl<TerminalSupplyMapper, TerminalSupply> {
    public List<TerminalSupply> findByTerminalCodes(List<String> terminalCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalSupply::getTerminalCode, terminalCodeList)).list();
    }

    public void deleteByTerminalCodes(List<String> terminalCodeList) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalSupply::getTerminalCode, terminalCodeList);
        ((TerminalSupplyMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public List<TerminalSupply> findByPositionCodesAndTerminalCodes(List<String> positionCodes, List<String> terminalCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TerminalSupply::getSupplyType, (Object)TerminalSupplyTypeEnum.DEFAULT.getValue())).in(TerminalSupply::getPositionCode, positionCodes)).in(TerminalSupply::getTerminalCode, terminalCodeList)).list();
    }

    public List<TerminalSupply> findByCustomerUserNameAndTerminalCodes(String userName, List<String> terminalCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TerminalSupply::getSupplyType, (Object)TerminalSupplyTypeEnum.CUSTOMER_USER.getValue())).eq(TerminalSupply::getUserName, (Object)userName)).in(TerminalSupply::getTerminalCode, terminalCodeList)).list();
    }

    public List<TerminalSupply> findByCustomerCodeAndTerminalCodesAndSupplyType(String customerCode, List<String> terminalCodeList, String supplyType) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotBlank((CharSequence)supplyType), TerminalSupply::getSupplyType, (Object)supplyType)).eq(TerminalSupply::getCustomerCode, (Object)customerCode)).in(TerminalSupply::getTerminalCode, terminalCodeList)).list();
    }

    public List<TerminalSupply> findByIds(List<String> supplyIdList) {
        return ((TerminalSupplyMapper)this.baseMapper).selectBatchIds(supplyIdList);
    }

    public List<TerminalSupply> findByUserNames(List<String> userNameList, String value) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TerminalSupply::getSupplyType, (Object)value)).in(TerminalSupply::getUserName, userNameList)).eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public Set<String> findTerminalSupplyCustomerCodeSet(String terminalCode, Set<String> productCodeSet, Set<String> productLevelCodeSet) {
        Set<String> curSet;
        HashSet set = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(productCodeSet) && CollectionUtils.isNotEmpty(curSet = ((TerminalSupplyMapper)this.baseMapper).findTerminalSupplyCustomerCodeSetByProduct(terminalCode, "", "1", productCodeSet, TenantUtils.getTenantCode()))) {
            set.addAll(curSet);
        }
        if (CollectionUtils.isNotEmpty(productLevelCodeSet) && CollectionUtils.isNotEmpty(curSet = ((TerminalSupplyMapper)this.baseMapper).findTerminalSupplyCustomerCodeSetByProductLevel(terminalCode, "", "2", productLevelCodeSet, TenantUtils.getTenantCode()))) {
            set.addAll(curSet);
        }
        if (CollectionUtils.isNotEmpty(curSet = ((TerminalSupplyMapper)this.baseMapper).findTerminalSupplyCustomerCodeSetByNoProduct(terminalCode, TenantUtils.getTenantCode()))) {
            set.addAll(curSet);
        }
        return set;
    }

    public List<TerminalSupply> findByCustomerCodes(Set<String> customerCodeSet) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalSupply::getCustomerCode, customerCodeSet)).list();
    }

    public List<TerminalSupply> findByPositionCodes(Set<String> positionCodeSet) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalSupply::getPositionCode, positionCodeSet)).list();
    }
}

