/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalTag;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalTagRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalTagService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalTagService")
public class TerminalTagServiceImpl
implements TerminalTagService {
    @Autowired(required=false)
    private TerminalTagRepository terminalTagRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static volatile Cache<String, List<TerminalTag>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalTagServiceImpl() {
        if (cache != null) return;
        Class<TerminalTagServiceImpl> clazz = TerminalTagServiceImpl.class;
        synchronized (TerminalTagServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<TerminalTag> findByTerminalCodes(Set<String> terminalCodeSet) {
        if (CollectionUtils.isEmpty(terminalCodeSet)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), terminalCodeSet});
        List<TerminalTag> graph = (List<TerminalTag>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.terminalTagRepository.findByTerminalCodes(terminalCodeSet);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public TerminalTag create(TerminalTag terminalTag) {
        this.createValidation(terminalTag);
        terminalTag.setTenantCode(TenantUtils.getTenantCode());
        terminalTag.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        terminalTag.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.terminalTagRepository.saveOrUpdate((Object)terminalTag);
        return terminalTag;
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalTagRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(TerminalTag terminalTag) {
        Validate.notNull((Object)((Object)terminalTag), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        terminalTag.setTenantCode(TenantUtils.getTenantCode());
        terminalTag.setId(null);
        Validate.notBlank((CharSequence)terminalTag.getTagDescription(), (String)"\u7f3a\u5931\u6807\u7b7e\u63cf\u8ff0", (Object[])new Object[0]);
        Validate.isTrue((terminalTag.getTagDescription().length() < 64 ? 1 : 0) != 0, (String)"\u6807\u7b7e\u63cf\u8ff0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

