/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.customer.user.sdk.event.CustomerUserEventListener;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerUserEventListenerImpl
implements CustomerUserEventListener {
    @Autowired(required=false)
    private TerminalSupplyService terminalSupplyService;
    @Autowired(required=false)
    private TerminalService terminalService;

    public void onDelete(List<CustomerUserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> userNameList = list.stream().map(CustomerUserVo::getUserName).collect(Collectors.toList());
        List<TerminalSupply> supplyList = this.terminalSupplyService.findByUserNames(userNameList);
        if (CollectionUtils.isEmpty(supplyList)) {
            return;
        }
        List<String> terminalCodes = supplyList.stream().map(TerminalSupply::getTerminalCode).collect(Collectors.toList());
        List<Terminal> terminalList = this.terminalService.findByTerminalCodes(terminalCodes);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(terminalList), (String)"\u8be5\u5ba2\u6237\u7528\u6237\u5b58\u5728\u5173\u8054\u7ec8\u7aef\u4fe1\u606f\uff0c\u65e0\u6cd5\u5220\u9664!", (Object[])new Object[0]);
    }
}

