package com.biz.crm.mdm.business.terminal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.sdk.dto.NearbyTerminalsDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName TerminalMiniProgramController
 * @Description 小程序终端信息接口
 * @AUTHOR WangJJ
 * @DATE 2023/6/29 11:27
 **/
@Slf4j
@Api(tags = "小程序终端信息接口")
@RestController
@RequestMapping(value = {"/v1/rest/miniProgram/terminal"})
public class TerminalMiniProgramController {

    @Autowired(required = false)
    private TerminalVoService terminalVoService;

    @GetMapping("/findNearbyTerminals")
    @ApiOperation(value = "附近核销门店")
    public Result<Page<TerminalVo>> findNearbyTerminals(@PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "dto", value = "查询参数") NearbyTerminalsDto dto){
        try {
            return Result.ok(this.terminalVoService.findNearbyTerminals(pageable, dto));
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }


}
