package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindOrgDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/11/4
 */
@Slf4j
@Api(tags = "终端管理: TerminalROrg: 终端管理组织")
@RestController
@RequestMapping(value = {"/v1/terminal/terminalRelaOrg"})
public class TerminalRelaOrgController {

  @Autowired(required = false) private TerminalRelaOrgService terminalRelaOrgService;

  @ApiOperation(value = "更换组织")
  @PatchMapping(value = {"/rebindOrg"})
  public Result<?> rebindOrg(@RequestBody TerminalRebindOrgDto dto) {
    try {
      this.terminalRelaOrgService.rebindOrg(dto);
      return Result.ok("更换组织成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
