package com.biz.crm.mdm.business.terminal.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.sdk.deprecated.vo.MdmTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Liao Hua
 * @date 2020/9/3 3:30 下午
 */
@Slf4j
@RestController
@RequestMapping("/mdmTerminalController")
@Api(tags = "终端信息")
@Deprecated
public class MdmTerminalController {

  @Autowired(required = false)
  private TerminalService terminalService;

  @Autowired(required = false)
  private TerminalVoService terminalVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @ApiOperation(value = "终端信息页面查询主列表（其它功能请勿使用）")
  @PostMapping("/pageList")
  public Result<PageResult<Terminal>> pageList(@RequestBody MdmTerminalVo mdmTerminalReqVo) {
    try {
      mdmTerminalReqVo = Optional.ofNullable(mdmTerminalReqVo).orElse(new MdmTerminalVo());
      TerminalPaginationDto dto = nebulaToolkitService
          .copyObjectByWhiteList(mdmTerminalReqVo, TerminalPaginationDto.class, HashSet.class,
              ArrayList.class);
      Page<Terminal> page = terminalService
          .findByConditions(
              PageRequest.of(mdmTerminalReqVo.getPageNum(), mdmTerminalReqVo.getPageSize()), dto);
      PageResult<Terminal> pageResult = PageResult.<Terminal>builder()
          .data(page.getRecords())
          .count(page.getTotal())
          .build();
      return Result.ok(pageResult);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "terminalCode", value = "终端编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/query")
  public Result<TerminalVo> query(@RequestParam(value = "id", required = false) String id,
      @RequestParam(value = "terminalCode", required = false) String terminalCode) {
    List<String> ids = Lists.newLinkedList();
    List<String> terminalCodes = Lists.newLinkedList();
    if (StringUtils.isNotBlank(id)) {
      ids.add(id);
    }
    if (StringUtils.isNotBlank(terminalCode)) {
      terminalCodes.add(terminalCode);
    }
    try {
      TerminalVo vo = null;
      List<TerminalVo> list = this.terminalVoService
          .findDetailsByIdsOrTerminalCodes(ids, terminalCodes);
      if (CollectionUtils.isNotEmpty(list)) {
        vo = list.stream().findFirst().orElse(null);
      }
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result<TerminalVo> save(@RequestBody TerminalDto dto) {
    try {
      TerminalVo current = this.terminalVoService.create(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result<TerminalVo> update(@RequestBody TerminalDto dto) {
    try {
      TerminalVo current = this.terminalVoService.update(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    try {
      this.terminalService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.terminalService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.terminalService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}