package com.biz.crm.mdm.business.terminal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_terminal_address")
@Table(name = "mdm_terminal_address")
@ApiModel("终端收货地址类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_address", comment = "终端收货地址")
public class TerminalAddressEntity extends UuidEntity {
  @ApiModelProperty(value = "终端id（EAS）")
  @TableField(value = "sources_id")
  @Column(name = "sources_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '终端id（EAS）'")
  private String sourcesId;

  @ApiModelProperty(value = "终端id（兆信）")
  @TableField(value = "terminal_id")
  @Column(name = "terminal_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '终端id（兆信）'")
  private String terminalId;

  @ApiModelProperty(value = "终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '终端编码'")
  private String terminalCode;

  @ApiModelProperty(value = "终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '终端名称'")
  private String terminalName;

  @ApiModelProperty(value = "省编码")
  @TableField(value = "province")
  @Column(name = "province", length = 64, columnDefinition = "VARCHAR(64) COMMENT '省编码'")
  private String province;

  @ApiModelProperty(value = "市编码")
  @TableField(value = "city")
  @Column(name = "city", length = 64, columnDefinition = "VARCHAR(64) COMMENT '市编码'")
  private String city;

  @ApiModelProperty(value = "区/县编码")
  @TableField(value = "district")
  @Column(name = "district", length = 64, columnDefinition = "VARCHAR(64) COMMENT '区/县编码'")
  private String district;

  @ApiModelProperty(value = "省名称")
  @TableField(value = "province_name")
  @Column(name = "province_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '省名称'")
  private String provinceName;

  @ApiModelProperty(value = "市名称")
  @TableField(value = "city_name")
  @Column(name = "city_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '市名称'")
  private String cityName;

  @ApiModelProperty(value = "区/县名称")
  @TableField(value = "district_name")
  @Column(name = "district_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '区/县名称'")
  private String districtName;

  @ApiModelProperty(value = "详细地址")
  @TableField(value = "address_detail")
  @Column(name = "address_detail", length = 255,columnDefinition = "VARCHAR(128) COMMENT '详细地址'")
  private String addressDetail;

  @ApiModelProperty(value = "经度")
  @TableField(value = "longtitude")
  @Column(name = "longtitude",columnDefinition = "decimal(12,8) COMMENT '经度'")
  private BigDecimal longtitude;

  @ApiModelProperty(value = "纬度")
  @TableField(value = "latitude")
  @Column(name = "latitude",columnDefinition = "decimal(12,8) COMMENT '纬度'")
  private BigDecimal latitude;

  @ApiModelProperty(value = "最大签收范围")
  @TableField(value = "recieve_range")
  @Column(name = "recieve_range",length = 10,columnDefinition = "VARCHAR(10) COMMENT '详细地址'")
  private String recieveRange;

  @ApiModelProperty(value = "状态")
  @TableField(value = "status")
  @Column(name = "status",length = 10,columnDefinition = "VARCHAR(10) COMMENT '状态'")
  private String status;

  @ApiModelProperty(value = "创建时间")
  @TableField(value = "creat_date")
  @Column(name = "creat_date",length = 32,columnDefinition = "VARCHAR(32) COMMENT '创建时间'")
  private String creatDate;

  @ApiModelProperty(value = "是否开启距离校验")
  @TableField(value = "is_distance_inspect")
  @Column(name = "is_distance_inspect",length = 32,columnDefinition = "VARCHAR(32) COMMENT '是否开启距离校验'")
  private String isDistanceInspect;

  @ApiModelProperty(value = "是否默认地址")
  @TableField(value = "is_defult_address")
  @Column(name = "is_defult_address",length = 10,columnDefinition = "VARCHAR(10) COMMENT '是否默认地址'")
  private String isDefultAddress;
}
