package com.biz.crm.mdm.business.terminal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lgq
 * @date 2023/6/15 10:49
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_terminal_person")
@Table(name = "mdm_terminal_person")
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_person", comment = "终端业务员")
@ApiModel(value = "TerminalPersonEntity", description = "终端业务员")
public class TerminalPersonEntity extends TenantFlagOpEntity {
  @ApiModelProperty(value = "人员id（EAS）")
  @TableField(value = "uer_sources_id")
  @Column(name = "uer_sources_id", length = 64, columnDefinition = "varchar(64) COMMENT '人员id（EAS）'")
  private String uerSourcesId;

  @ApiModelProperty(value = "人员id（兆信）")
  @TableField(value = "user_id")
  @Column(name = "user_id", length = 64, columnDefinition = "varchar(64) COMMENT '人员id（兆信）'")
  private String userId;

  @ApiModelProperty(value = "用户名")
  @TableField(value = "nick_name")
  @Column(name = "nick_name", length = 128, columnDefinition = "varchar(128) COMMENT '用户名'")
  private String nickName;

  @ApiModelProperty(value = "真实姓名")
  @TableField(value = "name")
  @Column(name = "name", length = 128, columnDefinition = "varchar(128) COMMENT '真实姓名'")
  private String name;

  @ApiModelProperty(value = "终端id（EAS）")
  @TableField(value = "sources_id")
  @Column(name = "sources_id", length = 64, columnDefinition = "varchar(64) COMMENT '终端id（EAS）'")
  private String sourcesId;

  @ApiModelProperty(value = "终端id（兆信）")
  @TableField(value = "terminal_id")
  @Column(name = "terminal_id", length = 64, columnDefinition = "varchar(64) COMMENT '终端id（兆信）'")
  private String terminalId;

  @ApiModelProperty(value = "终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  @ApiModelProperty(value = "终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", length = 128, columnDefinition = "varchar(128) COMMENT '终端名称'")
  private String terminalName;

  @ApiModelProperty(value = "手机")
  @TableField(value = "phone")
  @Column(name = "phone", length = 128, columnDefinition = "varchar(128) COMMENT '手机'")
  private String phone;

  @ApiModelProperty(value = "状态")
  @TableField(value = "status")
  @Column(name = "status", length = 10, columnDefinition = "varchar(10) COMMENT '状态'")
  private String status;

  @ApiModelProperty(value = "操作")
  @TableField(value = "opt")
  @Column(name = "opt", length = 10, columnDefinition = "varchar(10) COMMENT '操作'")
  private String opt;
}
