package com.biz.crm.mdm.business.terminal.local.entity;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端与组织关联表(TerminalROrg)实体类
 *
 * @author sunx
 * @since 2021-10-18 18:21:03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_terminal_r_org")
@Table(
    name = "mdm_terminal_r_org"
//        ,
//    indexes = {
//      @Index(
//          name = "mdm_terminal_r_org_index",
//          columnList = "tenant_code,terminal_code,org_code",
//          unique = true),
//    }
    )
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_r_org", comment = "终端与组织关联表")
@ApiModel(value = "TerminalROrg", description = "终端与组织关联表")
public class TerminalRelaOrg extends TenantEntity {

  private static final long serialVersionUID = -1411224807698958231L;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '组织编码'")
  private String orgCode;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name", length = 64, columnDefinition = "varchar(64) COMMENT '组织名称'")
  private String orgName;


  @ApiModelProperty(value = "终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", length = 128, columnDefinition = "varchar(128) COMMENT '终端名称'")
  private String terminalName;

  @ApiModelProperty(value = "终端id（EAS）")
  @TableField(value = "sources_id")
  @Column(name = "sources_id", length = 64, columnDefinition = "varchar(64) COMMENT '终端id（EAS）'")
  private String sourcesId;

  @ApiModelProperty(value = "终端id（兆信）")
  @TableField(value = "terminal_id")
  @Column(name = "terminal_id", length = 64, columnDefinition = "varchar(64) COMMENT '终端id（兆信）'")
  private String terminalId;

  @ApiModelProperty(value = "关联组织id（EAS）")
  @TableField(value = "sources_org_id")
  @Column(name = "sources_org_id", length = 64, columnDefinition = "varchar(64) COMMENT '关联组织id（EAS）'")
  private String sourcesOrgId;

  @ApiModelProperty(value = "状态")
  @TableField(value = "status")
  @Column(name = "status", length = 10, columnDefinition = "varchar(10) COMMENT '状态'")
  private String status;

  @ApiModelProperty(value = "操作")
  @TableField(value = "opt")
  @Column(name = "opt", length = 10, columnDefinition = "varchar(10) COMMENT '操作'")
  private String opt;


  @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY, jdbcType = VARCHAR)
  @Column(name = "del_flag", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '数据状态（删除状态）'")
  private String delFlag;


  @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY, jdbcType = VARCHAR)
  @Column(name = "enable_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '数据业务状态（启用状态）'")
  private String enableStatus;

  @TableField(value = "remark", jdbcType = VARCHAR)
  @Column(name = "remark", nullable = true, length = 400, columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;
}
