package com.biz.crm.mdm.business.terminal.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalAddressEntity;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalAddressMapper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;


@Component
public class TerminalAddressRepository extends
    ServiceImpl<TerminalAddressMapper, TerminalAddressEntity> {


    public List<TerminalAddressEntity> findByTerminalCode(List<String> terminalCodeList) {
        return this.lambdaQuery()
                .in(TerminalAddressEntity::getTerminalCode,terminalCodeList)
                .list();
    }

    public List<TerminalAddressEntity> findByTerminalIds(List<String> terminalIds){
        if (CollectionUtils.isEmpty(terminalIds)){
            return Lists.newArrayList();
        }
        List<TerminalAddressEntity> list = this.lambdaQuery().in(TerminalAddressEntity::getTerminalId, terminalIds).list();
        if (CollectionUtils.isEmpty(terminalIds)){
            return Lists.newArrayList();
        }
        return list;
    }
}
