package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalContactMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 终端扩展信息(repository)
 *
 * @author sunx
 * @since 2021-10-18 17:47:45
 */
@Component
public class TerminalContactRepository extends ServiceImpl<TerminalContactMapper, TerminalContact> {

  /**
   * 根据编码获取对应关系的数据集合
   *
   * @param terminalCodeList
   * @return
   */
  public List<TerminalContact> findByTerminalCodes(List<String> terminalCodeList) {
    return this.lambdaQuery().eq(TerminalContact::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalContact::getTerminalCode, terminalCodeList).list();
  }

  public void deleteByTerminalCodes(List<String> terminalCodeList) {
    LambdaQueryWrapper<TerminalContact> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(TerminalContact::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalContact::getTerminalCode, terminalCodeList);
    baseMapper.delete(lambdaQuery);
  }
}
