package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalRelaOrgMapper;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 终端与组织关联表(repository)
 *
 * @author sunx
 * @since 2021-10-18 17:48:34
 */
@Component
public class TerminalRelaOrgRepository extends ServiceImpl<TerminalRelaOrgMapper, TerminalRelaOrg> {

  private static final Integer SIZE = 1000;

  /**
   * 根据终端编码获取关系集合
   *
   * @param terminalCodeList
   * @return
   */
  public List<TerminalRelaOrg> findByTerminalCodes(List<String> terminalCodeList) {
    return this.lambdaQuery()
        .eq(TerminalRelaOrg::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalRelaOrg::getTerminalCode, terminalCodeList)
        .list();
  }

  public void deleteByTerminalCodes(List<String> terminalCodeList) {
    LambdaQueryWrapper<TerminalRelaOrg> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(TerminalRelaOrg::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalRelaOrg::getTerminalCode, terminalCodeList);
    baseMapper.delete(lambdaQuery);
  }

  public void deleteByOrgCodesAndTerminalCodes(
      List<String> orgCodeList, List<String> terminalCodeList) {
    LambdaQueryWrapper<TerminalRelaOrg> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(TerminalRelaOrg::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalRelaOrg::getOrgCode, orgCodeList)
        .in(TerminalRelaOrg::getTerminalCode, terminalCodeList);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据组织编码集合获取关联信息集合
   *
   * @param orgCodes
   * @return
   */
  public List<TerminalRelaOrg> findByOrgCodes(List<String> orgCodes) {
    return this.lambdaQuery()
        .eq(TerminalRelaOrg::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalRelaOrg::getOrgCode, orgCodes)
        .list();
  }

  /**
   * 获取审批通过且未删除的经销商对应的组织关系明细
   *
   * @param orgCodes
   * @return
   */
  public List<TerminalRelaOrg> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
    List<TerminalRelaOrg> list = Lists.newArrayList();
    String processStatus = ProcessStatusEnum.PASS.getDictCode();
    String delFlag = DelFlagStatusEnum.NORMAL.getCode();
    String tenantCode = TenantUtils.getTenantCode();
    for (List<String> item : Lists.partition(Lists.newArrayList(orgCodes), SIZE)) {
      List<TerminalRelaOrg> cur =
          this.baseMapper.findAllowSaleTerminalByOrgCodes(item, processStatus, delFlag, tenantCode);
      if (CollectionUtils.isEmpty(cur)) {
        continue;
      }
      list.addAll(cur);
    }
    return list;
  }
}
