package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalTag;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalTagMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 终端标签(repository)
 *
 * @author sunx
 * @date 2021-11-02 13:48:02
 */
@Component
public class TerminalTagRepository extends ServiceImpl<TerminalTagMapper, TerminalTag> {

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate().in(TerminalTag::getId, ids)
        .eq(TerminalTag::getTenantCode,TenantUtils.getTenantCode())    //新增租户编号判断条件
        .set(TerminalTag::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
  }

  public List<TerminalTag> findByTerminalCodes(Set<String> terminalCodeSet) {
    return this.lambdaQuery()
        .eq(TerminalTag::getTenantCode, TenantUtils.getTenantCode())
        .eq(TerminalTag::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(TerminalTag::getTerminalCode, terminalCodeSet)
        .list();
  }
}
