package com.biz.crm.mdm.business.terminal.local.service;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindOrgDto;
import java.util.List;

/**
 * 终端与组织关联表(TerminalROrg)表服务接口
 *
 * @author sunx
 * @since 2021-10-18 17:48:34
 */
public interface TerminalRelaOrgService {

  /**
   * 根据终端编码集合获取匹配信息
   *
   * @param terminalCodeList
   * @return
   */
  List<TerminalRelaOrg> findByTerminalCodes(List<String> terminalCodeList);

  /**
   * 批量保存
   *
   * @param list
   * @param terminalCode
   */
  void saveBatch(List<TerminalRelaOrg> list, String terminalCode);

  /**
   * 更换终端组织
   *
   * @param dto
   */
  void rebindOrg(TerminalRebindOrgDto dto);

  /**
   * 根据组织编码集合获取关联信息集合
   *
   * @param orgCodes
   * @return
   */
  List<TerminalRelaOrg> findByOrgCodes(List<String> orgCodes);

  /**
   * 根据终端编码集合删除关联信息 （物理删除）
   *
   * @param terminalCodes
   */
  void deleteByTerminalCodes(List<String> terminalCodes);

  /**
   * 新增组织信息
   *
   * @param orgCode
   * @param terminalCode
   * @param tenantCode
   */
  void create(String orgCode, String terminalCode, String tenantCode);
}
