package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalPersonEntity;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalPersonRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalPersonVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalPersonVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author lgq
 * @date 2023/6/15 17:36
 */
@Service
public class TerminalPersonVoServiceImpl implements TerminalPersonVoService {
  @Autowired
  private TerminalPersonRepository terminalPersonRepository;

 @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void saveBatch(List<TerminalPersonVo> personVos, String terminalId) {
      this.terminalPersonRepository.lambdaUpdate().eq(TerminalPersonEntity::getTerminalId,terminalId).remove();
      if(CollectionUtils.isNotEmpty(personVos)){
        List<TerminalPersonEntity> personList = (List<TerminalPersonEntity>) this.nebulaToolkitService.copyCollectionByBlankList(personVos, TerminalPersonVo.class, TerminalPersonEntity.class, HashSet.class, ArrayList.class);
        this.terminalPersonRepository.saveBatch(personList);
      }
  }

  @Override
  public List<TerminalPersonEntity> findTerminalPerson(List<String> terminalIdList) {
      if (CollectionUtils.isEmpty(terminalIdList)){
          return Lists.newArrayList();
      }
   return this.terminalPersonRepository.lambdaQuery().in(TerminalPersonEntity::getTerminalId,terminalIdList).list();
  }

    @Override
    public List<TerminalPersonEntity> findTerminalPersonByCode(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)){
            return Lists.newArrayList();
        }
        return this.terminalPersonRepository.lambdaQuery()
                .in(TerminalPersonEntity::getTerminalCode,terminalCodeList)
                .list();
    }
}
