/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPageDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalAddressVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u7ba1\u7406: Terminal: \u7ec8\u7aef\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/terminal/terminal"})
public class TerminalController {
    private static final Logger log = LoggerFactory.getLogger(TerminalController.class);
    @Autowired(required=false)
    private TerminalService terminalService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Terminal>> findByConditions(@PageableDefault(value=50) Pageable pageable, TerminalPaginationDto paginationDto) {
        try {
            paginationDto = Optional.ofNullable(paginationDto).orElse(new TerminalPaginationDto());
            paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            Page<Terminal> result = this.terminalService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.terminalService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.terminalService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.terminalService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u5458\u8d26\u53f7\u83b7\u53d6\u672c\u6708\u7684\u5df2\u5b8c\u6210\u62dc\u8bbf\u6570")
    @GetMapping(value={"findCountByCreateAccountAndFromTypeAndDateType"})
    public Result<?> findCountByCreateAccountAndDateTypeAndFromType(@ApiParam(name="createAccount", value="\u4eba\u5458\u8d26\u53f7") @RequestParam(value="createAccount", required=false) String createAccount, @ApiParam(name="fromType", value="\u4e1a\u52a1\u6765\u6e90\u7cfb\u7edf") @RequestParam(value="fromType") String fromType, @ApiParam(name="dateType", value="\u65e5\u671f\u7c7b\u578b\uff1amonth,week,day") @RequestParam(value="dateType") String dateType) {
        try {
            Map<String, Integer> map = this.terminalService.findCountByCreateAccountAndDateTypeAndFromType(createAccount, dateType, fromType);
            return Result.ok(map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec8\u7aef\u6536\u8d27\u5730\u5740")
    @GetMapping(value={"/terminalAddressDetail"})
    public Result<List<TerminalAddressVo>> terminalAddressDetail(@ApiParam(value="\u7ec8\u7aefid\uff08\u5146\u4fe1\uff09") @RequestParam(name="terminalId") String terminalId) {
        try {
            List<TerminalAddressVo> terminalAddressVoList = this.terminalService.terminalAddressDetail(terminalId);
            return Result.ok(terminalAddressVoList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec8\u7aef\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/findByTerminalPageDto"})
    public Result<Page<TerminalPageVo>> findByTerminalPageDto(@PageableDefault(value=50) Pageable pageable, @RequestBody TerminalPageDto dto) {
        try {
            Page<TerminalPageVo> page = this.terminalService.findByTerminalPageDto(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

