/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalBindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalUnbindSupplyDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u7ba1\u7406: TerminalSupply: \u4f9b\u8d27\u5173\u7cfb"})
@RestController
@RequestMapping(value={"/v1/terminal/terminalSupply"})
public class TerminalSupplyController {
    private static final Logger log = LoggerFactory.getLogger(TerminalSupplyController.class);
    @Autowired(required=false)
    private TerminalSupplyService terminalSupplyService;

    @ApiOperation(value="\u4f9b\u8d27\u5173\u7cfb\u7ed1\u5b9a")
    @PatchMapping(value={"/bind"})
    public Result<?> bind(@RequestBody TerminalBindSupplyDto dto) {
        try {
            this.terminalSupplyService.bind(dto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u89e3\u9664\u7528\u6237\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbind"})
    public Result<?> unbind(@RequestBody TerminalUnbindSupplyDto dto) {
        try {
            this.terminalSupplyService.unbind(dto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66ff\u6362\u7528\u6237\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/rebind"})
    public Result<?> rebind(@RequestBody TerminalRebindSupplyDto dto) {
        try {
            this.terminalSupplyService.rebind(dto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u4fe1\u606f\u89e3\u9664\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindByCustomer"})
    public Result<?> unbindByCustomer(@RequestBody TerminalUnbindSupplyDto dto) {
        try {
            this.terminalSupplyService.unbindByCustomer(dto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u4fe1\u606f\u66ff\u6362\u4f9b\u8d27\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/rebindByCustomer"})
    public Result<?> rebindByCustomer(@RequestBody TerminalRebindSupplyDto dto) {
        try {
            this.terminalSupplyService.rebindByCustomer(dto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

