/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalTag;
import com.biz.crm.mdm.business.terminal.local.service.TerminalTagService;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u7ba1\u7406: TerminalTag: \u7ec8\u7aef\u6807\u7b7e"})
@RestController
@RequestMapping(value={"/v1/terminalTag/terminalTag"})
public class TerminalTagController {
    private static final Logger log = LoggerFactory.getLogger(TerminalTagController.class);
    @Autowired(required=false)
    private TerminalTagService terminalTagService;

    @ApiOperation(value="\u901a\u8fc7\u7ec8\u7aef\u7f16\u7801\u67e5\u8be2\u6807\u7b7e\u5217\u8868")
    @GetMapping(value={"/findByTerminalCode"})
    public Result<List<TerminalTag>> findByTerminalCode(@RequestParam(value="terminalCode") String terminalCode) {
        try {
            List<TerminalTag> list = this.terminalTagService.findByTerminalCodes(Sets.newHashSet((Object[])new String[]{terminalCode}));
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<TerminalTag> create(@RequestBody TerminalTag terminalTag) {
        try {
            TerminalTag current = this.terminalTagService.create(terminalTag);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u521b\u5efa")
    @PostMapping(value={"createBatch"})
    public Result createBatch(@RequestBody List<TerminalTag> terminalTag) {
        try {
            this.terminalTagService.createBatch(terminalTag);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.terminalTagService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

