/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.mapper.TerminalMapper;
import com.biz.crm.mdm.business.terminal.sdk.dto.NearbyTerminalsDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalLugAndLatQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPageDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalPageVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class TerminalRepository
extends ServiceImpl<TerminalMapper, Terminal> {
    private static final Integer SIZE = 1000;

    public Page<Terminal> findByConditions(Page<Terminal> page, TerminalPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((TerminalMapper)this.baseMapper).findByConditions(page, dto);
    }

    public Terminal findById(String id) {
        return (Terminal)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public List<Terminal> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public List<Terminal> findByTerminalCodes(List<String> terminalCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(Terminal::getTerminalCode, terminalCodes)).list();
    }

    public List<Terminal> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(CollectionUtils.isNotEmpty((Collection)ids), UuidEntity::getId, (Collection)ids)).or()).in(CollectionUtils.isNotEmpty((Collection)terminalCodes), Terminal::getTerminalCode, (Collection)terminalCodes);
        })).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Integer countByTerminalCode(String terminalCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(Terminal::getTerminalCode, (Object)terminalCode)).count();
    }

    public List<TerminalRelaOrgVo> findTerminalRelaOrgByOrgCodes(List<String> orgCodeList) {
        return ((TerminalMapper)this.baseMapper).findTerminalRelaOrgByOrgCodes(orgCodeList, TenantUtils.getTenantCode());
    }

    public List<Terminal> findByCustomerOrgCodes(List<String> customerOrgCodes, String tenantCode, String delFlag) {
        return ((TerminalMapper)this.baseMapper).findByCustomerOrgCodes(customerOrgCodes, tenantCode, delFlag);
    }

    public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        return ((TerminalMapper)this.baseMapper).findByTerminalCodeSearchDto(dto);
    }

    public List<Terminal> findByTerminalSearchDto(TerminalSearchDto dto) {
        return ((TerminalMapper)this.baseMapper).findByTerminalSearchDto(dto);
    }

    public List<Terminal> findByAmapIds(Set<String> amapIds) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(Terminal::getAmapId, amapIds)).list();
    }

    public Terminal findByProcessNumber(String processNumber) {
        return (Terminal)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WorkflowFlagOpEntity::getProcessNumber, (Object)processNumber)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getOrgCodeSet())) {
            return this.findItemTerminalQueryDto(dto);
        }
        HashSet set = Sets.newHashSet();
        for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getOrgCodeSet()), (int)SIZE)) {
            dto.setOrgCodeSet((Set)Sets.newHashSet((Iterable)item));
            Set<String> cur = this.findItemTerminalQueryDto(dto);
            if (CollectionUtils.isEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    private Set<String> findItemTerminalQueryDto(TerminalQueryDto dto) {
        HashSet set = Sets.newHashSet();
        if (CollectionUtils.isEmpty((Collection)dto.getTerminalCodeSet())) {
            return ((TerminalMapper)this.baseMapper).findByTerminalQueryDto(dto, TenantUtils.getTenantCode());
        }
        for (List item : Lists.partition((List)Lists.newArrayList((Iterable)dto.getTerminalCodeSet()), (int)SIZE)) {
            dto.setTerminalCodeSet((Set)Sets.newHashSet((Iterable)item));
            Set<String> cur = ((TerminalMapper)this.baseMapper).findByTerminalQueryDto(dto, TenantUtils.getTenantCode());
            if (!CollectionUtils.isNotEmpty(cur)) continue;
            set.addAll(cur);
        }
        return set;
    }

    public List<Terminal> findCountByCreateAccountAndFromTypeAndCreateTimeScope(String createAccount, String fromType, String startDate, String endDate) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidOpEntity::getCreateAccount, (Object)createAccount)).eq(Terminal::getFromType, (Object)fromType)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).between(UuidOpEntity::getCreateTime, (Object)startDate, (Object)endDate)).list();
    }

    public void updateByIdAndTenantCode(Terminal terminal, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{terminal.getId()});
        ((TerminalMapper)this.baseMapper).update((Object)terminal, (Wrapper)lambdaUpdateWrapper);
    }

    public void modifyShareBenefits(List<String> terminalCodeList, Boolean bool) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Terminal::getShareBenefits, (Object)bool)).set(Terminal::getShareBenefitsTime, (Object)new Date())).in(Terminal::getTerminalCode, terminalCodeList)).update();
    }

    public List<Terminal> findByLngAndLat(TerminalLugAndLatQueryDto dto, String tenantCode) {
        return ((TerminalMapper)this.baseMapper).findByLngAndLat(dto, tenantCode);
    }

    public Page<TerminalVo> findNearbyTerminals(Page page, NearbyTerminalsDto dto) {
        if (Objects.isNull(page) || Objects.isNull(dto)) {
            return new Page();
        }
        return ((TerminalMapper)this.baseMapper).findNearbyTerminals(page, dto, TenantUtils.getTenantCode());
    }

    public List<Terminal> findDetailByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Page<TerminalPageVo> findByTerminalPageDto(Page<TerminalVo> page, TerminalPageDto dto) {
        return ((TerminalMapper)this.baseMapper).findByTerminalPageDto(page, dto);
    }
}

