/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalPersonEntity;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalPersonRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalPersonVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalPersonVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalPersonVoServiceImpl
implements TerminalPersonVoService {
    @Autowired
    private TerminalPersonRepository terminalPersonRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<TerminalPersonVo> personVos, String terminalId) {
        ((LambdaUpdateChainWrapper)this.terminalPersonRepository.lambdaUpdate().eq(TerminalPersonEntity::getTerminalId, (Object)terminalId)).remove();
        if (CollectionUtils.isNotEmpty(personVos)) {
            List personList = (List)this.nebulaToolkitService.copyCollectionByBlankList(personVos, TerminalPersonVo.class, TerminalPersonEntity.class, HashSet.class, ArrayList.class, new String[0]);
            this.terminalPersonRepository.saveBatch(personList);
        }
    }

    @Override
    public List<TerminalPersonEntity> findTerminalPerson(List<String> terminalIdList) {
        if (CollectionUtils.isEmpty(terminalIdList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.terminalPersonRepository.lambdaQuery().in(TerminalPersonEntity::getTerminalId, terminalIdList)).list();
    }

    @Override
    public List<TerminalPersonEntity> findTerminalPersonByCode(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.terminalPersonRepository.lambdaQuery().in(TerminalPersonEntity::getTerminalCode, terminalCodeList)).list();
    }
}

