/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaCustomerOrg;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRelaCustomerOrgRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaCustomerOrgService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRebindCustomerOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalRCustomerOrgEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalRelaCustomerOrgService")
public class TerminalRelaCustomerOrgServiceImpl
implements TerminalRelaCustomerOrgService {
    @Autowired(required=false)
    private TerminalRelaCustomerOrgRepository terminalRelaCustomerOrgRepository;
    @Autowired(required=false)
    @Lazy
    private List<TerminalRCustomerOrgEventListener> terminalRCustomerOrgEventListeners;
    private static volatile Cache<String, List<TerminalRelaCustomerOrg>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalRelaCustomerOrgServiceImpl() {
        if (cache != null) return;
        Class<TerminalRelaCustomerOrgServiceImpl> clazz = TerminalRelaCustomerOrgServiceImpl.class;
        synchronized (TerminalRelaCustomerOrgServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<TerminalRelaCustomerOrg> findByTerminalCodes(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), terminalCodeList});
        List<TerminalRelaCustomerOrg> graph = (List<TerminalRelaCustomerOrg>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.terminalRelaCustomerOrgRepository.findByTerminalCodes(terminalCodeList);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public void saveBatch(List<TerminalRelaCustomerOrg> list, String terminalCode) {
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRelaCustomerOrgRepository.deleteByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<TerminalRelaCustomerOrg> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getTerminalCode()) || StringUtils.isBlank((CharSequence)a.getOrgCode()) || !terminalCode.equals(a.getTerminalCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u6216\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u7ec8\u7aef", (Object[])new Object[0]);
        Map<String, List<TerminalRelaCustomerOrg>> map = list.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrg::getOrgCode));
        map.entrySet().forEach(a -> Validate.isTrue((((List)a.getValue()).size() <= 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u7ec7\u4fe1\u606f", (Object[])new Object[0]));
        for (TerminalRelaCustomerOrg terminalRelaCustomerOrg : list) {
            terminalRelaCustomerOrg.setId(null);
            terminalRelaCustomerOrg.setTenantCode(TenantUtils.getTenantCode());
        }
        this.terminalRelaCustomerOrgRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void rebindOrg(TerminalRebindCustomerOrgDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getNewOrgCode(), (String)"\u66f4\u6362\u540e\u7684\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getTerminalCodeList()), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList deleteOrgCodeList = Lists.newArrayList((Object[])new String[]{dto.getNewOrgCode()});
        if (StringUtils.isNotBlank((CharSequence)dto.getOldOrgCode())) {
            deleteOrgCodeList.add(dto.getOldOrgCode());
        }
        this.terminalRelaCustomerOrgRepository.deleteByOrgCodesAndTerminalCodes(deleteOrgCodeList, dto.getTerminalCodeList());
        LinkedList list = Lists.newLinkedList();
        LinkedHashSet set = Sets.newLinkedHashSet((Iterable)dto.getTerminalCodeList());
        for (String terminalCode : set) {
            TerminalRelaCustomerOrg cur = new TerminalRelaCustomerOrg();
            cur.setId(null);
            cur.setTenantCode(TenantUtils.getTenantCode());
            cur.setTerminalCode(terminalCode);
            cur.setOrgCode(dto.getNewOrgCode());
            list.add(cur);
        }
        this.terminalRelaCustomerOrgRepository.saveBatch(list);
        if (CollectionUtils.isEmpty(this.terminalRCustomerOrgEventListeners)) {
            return;
        }
        for (TerminalRCustomerOrgEventListener terminalRCustomerOrgEventListener : this.terminalRCustomerOrgEventListeners) {
            terminalRCustomerOrgEventListener.onRebind(dto.getOldOrgCode(), dto.getNewOrgCode(), dto.getTerminalCodeList());
        }
    }

    @Override
    @Transactional
    public void deleteByTerminalCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        this.terminalRelaCustomerOrgRepository.deleteByTerminalCodes(terminalCodes);
    }

    @Override
    @Transactional
    public void create(String customerOrgCode, String terminalCode, String tenantCode) {
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalRelaCustomerOrgRepository.deleteByTerminalCodes(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (StringUtils.isBlank((CharSequence)customerOrgCode)) {
            return;
        }
        TerminalRelaCustomerOrg terminalRelaCustomerOrg = new TerminalRelaCustomerOrg();
        terminalRelaCustomerOrg.setTerminalCode(terminalCode);
        terminalRelaCustomerOrg.setOrgCode(customerOrgCode);
        terminalRelaCustomerOrg.setTenantCode(tenantCode);
        this.terminalRelaCustomerOrgRepository.save((Object)terminalRelaCustomerOrg);
    }
}

