/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.customer.user.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customer.user.sdk.vo.CustomerUserVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.MaterialProductVo;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupplyDetail;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalSupplyRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyDetailService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalSupplyPositionRegister;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.SupplyPositionPageVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyDetailVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalSupplyVoServiceImpl
implements TerminalSupplyVoService {
    @Autowired(required=false)
    private TerminalSupplyService terminalSupplyService;
    @Autowired(required=false)
    private TerminalSupplyDetailService terminalSupplyDetailService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TerminalSupplyRepository terminalSupplyRepository;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerUserVoService customerUserVoService;
    @Autowired(required=false)
    private TerminalSupplyPositionRegister terminalSupplyPositionRegister;

    public List<TerminalSupplyVo> findByTerminalCodes(List<String> terminalCodeList) {
        List<Object> re = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return re;
        }
        List<TerminalSupply> terminalSupplyList = this.terminalSupplyService.findByTerminalCodes(terminalCodeList);
        if (CollectionUtils.isEmpty(terminalSupplyList)) {
            return re;
        }
        List<String> supplyIdList = terminalSupplyList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getId())).map(UuidEntity::getId).collect(Collectors.toList());
        List<Object> detailList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(supplyIdList)) {
            detailList = this.terminalSupplyDetailService.findBySupplyIds(supplyIdList);
        }
        re = this.buildTerminalSupplyVoList(terminalSupplyList, detailList);
        return re;
    }

    public List<TerminalSupplyVo> findByCustomerCodes(Set<String> customerCodeSet) {
        List<Object> re = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(customerCodeSet)) {
            return re;
        }
        List<TerminalSupply> terminalSupplyList = this.terminalSupplyService.findByCustomerCodes(customerCodeSet);
        if (CollectionUtils.isEmpty(terminalSupplyList)) {
            return re;
        }
        List<String> supplyIdList = terminalSupplyList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getId())).map(UuidEntity::getId).collect(Collectors.toList());
        List<Object> detailList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty(supplyIdList)) {
            detailList = this.terminalSupplyDetailService.findBySupplyIds(supplyIdList);
        }
        re = this.buildTerminalSupplyVoList(terminalSupplyList, detailList);
        return re;
    }

    @Transactional
    public void saveBatch(List<TerminalSupplyDto> list, String terminalCode) {
        this.terminalSupplyService.saveBatch(list, terminalCode);
    }

    public void deleteByTerminalCodes(List<String> terminalCodes) {
        this.terminalSupplyService.deleteByTerminalCodes(terminalCodes);
    }

    public Set<String> findTerminalSupplyCustomerCodeSet(String terminalCode, String materialCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{terminalCode, materialCode})) {
            return Sets.newHashSet();
        }
        MaterialProductVo materialProductVo = this.productVoService.findMaterialProductVoByMaterialCode(materialCode);
        if (Objects.isNull(materialProductVo) || CollectionUtils.isEmpty((Collection)materialProductVo.getProductCodeSet()) && CollectionUtils.isEmpty((Collection)materialProductVo.getProductLevelCodeSet())) {
            return Sets.newHashSet();
        }
        return this.terminalSupplyRepository.findTerminalSupplyCustomerCodeSet(terminalCode, materialProductVo.getProductCodeSet(), materialProductVo.getProductLevelCodeSet());
    }

    private List<TerminalSupplyVo> buildTerminalSupplyVoList(List<TerminalSupply> terminalSupplyList, List<TerminalSupplyDetail> detailList) {
        List<TerminalSupplyVo> re = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(terminalSupplyList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalSupplyList, TerminalSupply.class, TerminalSupplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.initSupplyUser(re);
        this.initSupplyPosition(re);
        this.initSupplyCustomer(re);
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, TerminalSupplyDetail.class, TerminalSupplyDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            map = list.stream().collect(Collectors.groupingBy(TerminalSupplyDetailVo::getSupplyId));
        }
        for (TerminalSupplyVo vo : re) {
            vo.setDetails((List)map.get(vo.getId()));
        }
        return re;
    }

    private void initSupplyCustomer(List<TerminalSupplyVo> list) {
        Set customerCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).map(TerminalSupplyVo::getCustomerCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(customerCodeSet)) {
            return;
        }
        List customerVoList = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList(customerCodeSet));
        if (CollectionUtils.isEmpty((Collection)customerVoList)) {
            return;
        }
        Map<String, String> map = customerVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerCode(), a.getCustomerName()})).collect(Collectors.toMap(CustomerVo::getCustomerCode, CustomerVo::getCustomerName, (a, b) -> a));
        for (TerminalSupplyVo item : list) {
            item.setCustomerName(map.get(item.getCustomerCode()));
        }
    }

    private void initSupplyPosition(List<TerminalSupplyVo> list) {
        Set positionCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPositionCode())).map(TerminalSupplyVo::getPositionCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(positionCodeSet) || Objects.isNull(this.terminalSupplyPositionRegister)) {
            return;
        }
        List vos = this.terminalSupplyPositionRegister.onRequestByPositionCodes(positionCodeSet);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return;
        }
        Map map = vos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getPositionCode())).collect(Collectors.toMap(SupplyPositionPageVo::getPositionCode, Function.identity(), (a, b) -> a));
        for (TerminalSupplyVo item : list) {
            SupplyPositionPageVo cur;
            if (StringUtils.isBlank((CharSequence)item.getPositionCode()) || !map.containsKey(item.getPositionCode()) || Objects.isNull(cur = (SupplyPositionPageVo)map.get(item.getPositionCode()))) continue;
            item.setUnionName(cur.getUnionName());
            item.setFullName(cur.getFullName());
            item.setPositionName(cur.getPositionName());
            item.setOrgName(cur.getOrgName());
        }
    }

    private void initSupplyUser(List<TerminalSupplyVo> list) {
        Set userNameSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserName())).map(TerminalSupplyVo::getUserName).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(userNameSet)) {
            return;
        }
        List userVoList = this.customerUserVoService.findByUserNames(userNameSet);
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return;
        }
        Map<String, String> map = userVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getUserName(), a.getFullName()})).collect(Collectors.toMap(CustomerUserVo::getUserName, CustomerUserVo::getFullName, (a, b) -> a));
        for (TerminalSupplyVo item : list) {
            item.setFullName(map.get(item.getUserName()));
        }
    }
}

