/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.utils.DistanceUtil;
import com.biz.crm.mdm.business.customer.org.sdk.service.CustomerOrgVoSdkService;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.biz.crm.mdm.business.customer.sdk.dto.SupplyRelationshipDto;
import com.biz.crm.mdm.business.customer.sdk.enums.BuyerTypeEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.SupplyRelationshipSdkService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalAddressEntity;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalContact;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalPersonEntity;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaCustomerOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalTag;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalAddressRepository;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRelaOrgRepository;
import com.biz.crm.mdm.business.terminal.local.repository.TerminalRepository;
import com.biz.crm.mdm.business.terminal.local.service.TerminalContactService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalPersonVoService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaCustomerOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalTagService;
import com.biz.crm.mdm.business.terminal.sdk.dto.NearbyTerminalsDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalContactDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalLugAndLatQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalNewSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelaCustomerOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelaOrgDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.enums.TerminalVoExtendEnum;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalPersonVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaCustomerOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalTagVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TerminalVoServiceImpl
implements TerminalVoService {
    private static final Logger log = LoggerFactory.getLogger(TerminalVoServiceImpl.class);
    @Autowired(required=false)
    private TerminalService terminalService;
    @Autowired(required=false)
    private TerminalRelaOrgService terminalRelaOrgService;
    @Autowired(required=false)
    private TerminalRelaCustomerOrgService terminalRelaCustomerOrgService;
    @Autowired(required=false)
    private TerminalContactService terminalContactService;
    @Autowired(required=false)
    private TerminalSupplyVoService terminalSupplyVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerOrgVoSdkService customerOrgVoSdkService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private TerminalPersonVoService personVoService;
    @Autowired(required=false)
    private TerminalRepository terminalRepository;
    @Autowired(required=false)
    private TerminalRelaOrgRepository terminalRelaOrgRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private TerminalTagService terminalTagService;
    @Autowired
    private SupplyRelationshipSdkService supplyRelationshipSdkService;
    @Autowired(required=false)
    private TerminalAddressRepository addressRepository;
    public static final String TERMINAL_PROCESS_NAME = "\u7ec8\u7aef\u5ba1\u6279\u6d41\u7a0b";
    private static volatile Cache<String, List<TerminalVo>> cache = null;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Value(value="${crm.business.terminal.process-key:}")
    private String defaultProcessKey;

    public List<TerminalVo> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes) {
        List<Object> re = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids) && org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodes)) {
            return re;
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(ids, terminalCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return re;
        }
        re = this.convertEntityToVo(terminalList);
        return re;
    }

    @Transactional
    public TerminalVo create(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getTerminalCode())) {
            dto.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(dto.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(dto.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        terminal.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        dto.setTerminalCode(terminal.getTerminalCode());
        terminal.setTenantCode(TenantUtils.getTenantCode());
        this.terminalService.create(terminal);
        dto.setId(terminal.getId());
        this.bindExtInfo(dto);
        return this.buildByDtoAndTerminal(dto, terminal);
    }

    @Transactional
    public TerminalVo createAndSubmit(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        if (StringUtils.isEmpty((CharSequence)dto.getTerminalCode())) {
            dto.setTerminalCode((String)this.generateCodeService.generateCode("ZD", 1).get(0));
        } else {
            Integer count = this.terminalRepository.countByTerminalCode(dto.getTerminalCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(dto.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(dto);
        terminal.setTenantCode(TenantUtils.getTenantCode());
        this.terminalService.create(terminal);
        TerminalVo re = this.buildByDtoAndTerminal(dto, terminal);
        dto.setId(terminal.getId());
        terminal.setProcessNumber(this.commitProcess(dto));
        terminal.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        this.terminalRepository.updateByIdAndTenantCode(terminal, TenantUtils.getTenantCode());
        return re;
    }

    @Transactional
    public TerminalVo update(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        this.validateContacts(dto);
        Terminal terminal = (Terminal)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Terminal.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setTerminalCode(terminal.getTerminalCode());
        this.bindExtInfo(dto);
        this.terminalService.update(terminal);
        return this.buildByDtoAndTerminal(dto, terminal);
    }

    public List<TerminalVo> findSelectByKeyword(String keyword) {
        PageRequest pageable = PageRequest.of((int)0, (int)20);
        TerminalPaginationDto dto = new TerminalPaginationDto();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setKeyword(keyword);
        Page<Terminal> page = this.terminalService.findByConditions((Pageable)pageable, dto);
        if (Objects.isNull(page) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return Lists.newLinkedList();
        }
        ArrayList list = Lists.newArrayList();
        for (Terminal item : page.getRecords()) {
            TerminalVo cur = new TerminalVo();
            cur.setTerminalCode(item.getTerminalCode());
            cur.setTerminalName(item.getTerminalName());
            list.add(cur);
        }
        return list;
    }

    public List<TerminalVo> findMainDetailsByTerminalCodesUsePost(List<String> terminalCodeList) {
        return this.findMainDetailsByTerminalCodes(terminalCodeList);
    }

    public List<TerminalVo> findTerminalAndContactByTerminalCodes(List<String> terminalCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(null, terminalCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return Lists.newLinkedList();
        }
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        List terminalContactVos = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)terminalContactVos)) {
            terminalContactVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        Map<String, List<TerminalContactVo>> terminalContactVoMap = terminalContactVos.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        List terminalVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        terminalVos.forEach(terminalVo -> terminalVo.setContacts((List)terminalContactVoMap.get(terminalVo.getTerminalCode())));
        return terminalVos;
    }

    public List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return Lists.newLinkedList();
        }
        List<Terminal> terminalList = this.terminalService.findDetailsByIdsOrTerminalCodes(null, terminalCodeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return Lists.newLinkedList();
        }
        List<TerminalRelaOrg> terminalRelaOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodeList);
        Map map = terminalRelaOrgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()})).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toList())));
        Set orgCodeSet = terminalRelaOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrg::getOrgCode).collect(Collectors.toSet());
        List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodeSet));
        Map<Object, Object> mapOrg = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgVoList)) {
            mapOrg = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getOrgName()})).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
        }
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        Map<Object, Object> terminalContactVoMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(terminalContactList)) {
            List terminalContactVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
            terminalContactVoMap = terminalContactVos.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        }
        List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgs = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodeList);
        Map<Object, Object> terminalRelaCustomerOrgVoMap = new HashMap();
        Map<Object, Object> customerOrgVoMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(terminalRelaCustomerOrgs)) {
            List terminalRelaCustomerOrgVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaCustomerOrgs, TerminalRelaCustomerOrg.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            terminalRelaCustomerOrgVoMap = terminalRelaCustomerOrgVos.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrgVo::getTerminalCode));
            List customerOrgVos = this.customerOrgVoSdkService.findListByCodes(terminalRelaCustomerOrgVos.stream().map(TerminalRelaCustomerOrgVo::getOrgCode).collect(Collectors.toList()));
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerOrgVos)) {
                customerOrgVoMap = customerOrgVos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerOrgCode(), a.getCustomerOrgName()})).collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, CustomerOrgVo::getCustomerOrgName));
            }
        }
        List re = (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (TerminalVo item : re) {
            List terminalRelaCustomerOrgVos;
            List terminalContactVos;
            List curOrgCodeList = map.get(item.getTerminalCode());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(curOrgCodeList)) {
                LinkedList curList = Lists.newLinkedList();
                LinkedList orgNameList = Lists.newLinkedList();
                for (String orgCode : curOrgCodeList) {
                    TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
                    cur.setTerminalCode(item.getTerminalCode());
                    cur.setOrgCode(orgCode);
                    cur.setOrgName((String)mapOrg.get(orgCode));
                    curList.add(cur);
                    orgNameList.add(cur.getOrgName());
                }
                item.setOrgList((List)curList);
                item.setOrgNameStr(StringUtils.join((Iterable)orgNameList, (String)","));
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(terminalContactVos = (List)terminalContactVoMap.get(item.getTerminalCode())))) {
                item.setContacts(terminalContactVos);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(terminalRelaCustomerOrgVos = (List)terminalRelaCustomerOrgVoMap.get(item.getTerminalCode())))) continue;
            for (TerminalRelaCustomerOrgVo terminalRelaCustomerOrgVo : terminalRelaCustomerOrgVos) {
                terminalRelaCustomerOrgVo.setOrgName((String)customerOrgVoMap.get(terminalRelaCustomerOrgVo.getOrgCode()));
            }
            item.setCustomerOrgList(terminalRelaCustomerOrgVos);
        }
        return re;
    }

    public Page<TerminalVo> findByTerminalPaginationDto(Pageable pageable, TerminalPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Terminal> entityPage = this.terminalRepository.findByConditions((Page<Terminal>)page, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        pageResult.setRecords(this.convertEntityToVo(entityPage.getRecords()));
        return pageResult;
    }

    public Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
        dto = Optional.ofNullable(dto).orElse(new TerminalCodeSearchDto());
        return this.terminalService.findByTerminalCodeSearchDto(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<TerminalVo> findByAmapIds(Set<String> amapIds) {
        List<TerminalVo> graph;
        String cacheKey = StringUtils.join((Object[])new Set[]{amapIds});
        if (cache == null) {
            Class<TerminalVoServiceImpl> clazz = TerminalVoServiceImpl.class;
            // MONITORENTER : com.biz.crm.mdm.business.terminal.local.service.internal.TerminalVoServiceImpl.class
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(300L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // MONITOREXIT : clazz
        }
        if ((graph = (List<TerminalVo>)cache.getIfPresent((Object)cacheKey)) != null) return graph;
        graph = this.findByAmapIdsFromDB(amapIds);
        cache.put((Object)cacheKey, graph);
        return graph;
    }

    private List<TerminalVo> findByAmapIdsFromDB(Set<String> amapIds) {
        log.warn(" db \u67e5\u8be2 findByAmapIds ");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(amapIds)) {
            return Lists.newArrayList();
        }
        List<Terminal> list = this.terminalRepository.findByAmapIds(amapIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void submitAudit(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Terminal terminal = this.terminalRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet((Object[])new String[]{ProcessStatusEnum.PREPARE.getDictCode(), ProcessStatusEnum.REJECT.getDictCode(), ProcessStatusEnum.RECOVER.getDictCode()});
        Validate.isTrue((boolean)set.contains(terminal.getProcessStatus()), (String)"\u7ec8\u7aef\u72b6\u6001\u4e0d\u80fd\u6267\u884c\u63d0\u4ea4\u5ba1\u6838", (Object[])new Object[0]);
        dto.setTerminalCode(terminal.getTerminalCode());
        terminal.setProcessNumber(this.commitProcess(dto));
        terminal.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        terminal.setProcessRemark(processBusiness.getRemark());
        terminal.setProcessKey(processBusiness.getProcessKey());
        this.terminalRepository.updateByIdAndTenantCode(terminal, TenantUtils.getTenantCode());
    }

    public Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getTerminalCode(), dto.getTerminalName(), dto.getChannel(), dto.getOrgName(), dto.getDelFlag(), dto.getProcessStatus()})) {
            return Sets.newHashSet();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            OrgQueryDto queryDto = new OrgQueryDto();
            queryDto.setOrgName(dto.getOrgName());
            Set orgCodeSet = this.orgVoService.findByOrgQueryDto(queryDto);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgCodeSet)) {
                return Sets.newHashSet();
            }
            dto.setOrgCodeSet(orgCodeSet);
        }
        return this.terminalRepository.findByTerminalQueryDto(dto);
    }

    public Map<String, Set<String>> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Maps.newHashMap();
        }
        RelateOrgCodeQueryDto queryDto = new RelateOrgCodeQueryDto();
        queryDto.setOrgCodeSet(orgCodes);
        queryDto.setSearchType(Integer.valueOf(-1));
        Map orgRuleMap = this.orgVoService.findByRelateOrgCodeQueryDto(queryDto);
        if (CollectionUtils.isEmpty((Map)orgRuleMap)) {
            return Maps.newHashMap();
        }
        List<TerminalRelaOrg> list = this.terminalRelaOrgRepository.findAllowSaleTerminalByOrgCodes(orgRuleMap.keySet());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getOrgCode()}) && orgRuleMap.keySet().contains(a.getOrgCode())).collect(Collectors.groupingBy(TerminalRelaOrg::getTerminalCode, Collectors.mapping(TerminalRelaOrg::getOrgCode, Collectors.toSet())));
        HashMap re = Maps.newHashMap();
        for (Map.Entry item : map.entrySet()) {
            HashSet rule = Sets.newHashSet();
            for (String orgCode : item.getValue()) {
                String s = (String)orgRuleMap.get(orgCode);
                if (StringUtils.isBlank((CharSequence)s)) continue;
                rule.add(s);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rule)) continue;
            re.put(item.getKey(), rule);
        }
        return re;
    }

    public List<TerminalVo> findByTerminalSearchDto(TerminalSearchDto dto) {
        dto = Optional.ofNullable(dto).orElse(new TerminalSearchDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getOrgCodeSet()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getChannelSet()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getTagSet()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getTerminalCodeSet())) {
            return Lists.newArrayList();
        }
        List<Terminal> terminalList = this.terminalRepository.findByTerminalSearchDto(dto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void modifyShareBenefits(TerminalDto dto) {
        List terminalSupplyVoList;
        if (ObjectUtil.isNotEmpty((Object)dto) && CollUtil.isNotEmpty((Collection)dto.getTerminalCodeList()) && ObjectUtil.isNotEmpty((Object)dto.getShareBenefits())) {
            this.terminalRepository.modifyShareBenefits(dto.getTerminalCodeList(), dto.getShareBenefits());
        }
        if (CollUtil.isEmpty((Collection)(terminalSupplyVoList = this.terminalSupplyVoService.findByTerminalCodes(dto.getTerminalCodeList())))) {
            return;
        }
        Map<Object, Object> mapKeyCustomerCode = Maps.newHashMap();
        List<Object> list = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)terminalSupplyVoList)) {
            mapKeyCustomerCode = terminalSupplyVoList.stream().collect(Collectors.groupingBy(TerminalSupplyVo::getCustomerCode));
        }
        Set keySet = mapKeyCustomerCode.keySet();
        List customerVoList = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList(keySet));
        if (dto.getShareBenefits().booleanValue()) {
            List collect;
            if (CollUtil.isNotEmpty((Collection)customerVoList) && CollUtil.isNotEmpty(collect = customerVoList.stream().filter(item -> ObjectUtil.isEmpty((Object)item.getShareBenefits()) || item.getShareBenefits() == false).collect(Collectors.toList()))) {
                list = collect.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            }
        } else {
            List terminalSupplyVos = this.terminalSupplyVoService.findByCustomerCodes(keySet);
            Set stringList = terminalSupplyVos.stream().map(TerminalSupplyVo::getTerminalCode).collect(Collectors.toSet());
            if (dto.getTerminalCodeList().size() == stringList.size() && dto.getTerminalCodeList().containsAll(stringList)) {
                list.addAll(keySet);
            } else {
                List<Object> terminalList = new ArrayList();
                if (CollUtil.isNotEmpty((Collection)terminalSupplyVos)) {
                    List<String> str = terminalSupplyVos.stream().map(TerminalSupplyVo::getTerminalCode).collect(Collectors.toList());
                    terminalList = this.terminalService.findByTerminalCodes(str);
                }
                if (CollUtil.isNotEmpty(terminalList)) {
                    List collect = terminalList.stream().filter(item -> ObjectUtil.isNotEmpty((Object)item.getShareBenefits()) && item.getShareBenefits() != false).collect(Collectors.toList());
                    Map<String, List<TerminalSupplyVo>> listMap = terminalSupplyVos.stream().collect(Collectors.groupingBy(TerminalSupplyVo::getTerminalCode));
                    Set<String> set = listMap.keySet();
                    if (CollUtil.isNotEmpty(collect)) {
                        List<String> terminalCodes = collect.stream().map(Terminal::getTerminalCode).collect(Collectors.toList());
                        terminalCodes.forEach(set::remove);
                    }
                    for (String key : set) {
                        list.addAll(listMap.get(key).stream().map(TerminalSupplyVo::getCustomerCode).collect(Collectors.toSet()));
                    }
                }
            }
        }
        if (CollUtil.isNotEmpty((Collection)list)) {
            this.customerVoService.modifyShareBenefits((List)list, dto.getShareBenefits());
        }
    }

    private void bindExtInfo(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List orgList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getOrgList())) {
            for (Object item : dto.getOrgList()) {
                item.setTerminalCode(dto.getTerminalCode());
            }
            orgList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getOrgList(), TerminalRelaOrgDto.class, TerminalRelaOrg.class, HashSet.class, ArrayList.class, new String[0]);
            orgList.forEach(a -> {
                a.setTerminalCode(dto.getTerminalCode());
                a.setTenantCode(TenantUtils.getTenantCode());
                a.setTerminalId(dto.getId());
                a.setSourcesId(dto.getSourcesId());
                a.setTerminalCode(dto.getTerminalName());
            });
        }
        this.terminalRelaOrgService.saveBatch(orgList, dto.getTerminalCode());
        List customerOrgList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerOrgList())) {
            for (Object item : dto.getCustomerOrgList()) {
                item.setTerminalCode(dto.getTerminalCode());
            }
            customerOrgList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerOrgList(), TerminalRelaCustomerOrgDto.class, TerminalRelaCustomerOrg.class, HashSet.class, ArrayList.class, new String[0]);
            customerOrgList.forEach(a -> a.setTerminalCode(dto.getTerminalCode()));
            customerOrgList.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
        }
        this.terminalRelaCustomerOrgService.saveBatch(customerOrgList, dto.getTerminalCode());
        List contactList = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getContacts())) {
            for (Object item : dto.getContacts()) {
                item.setTerminalCode(dto.getTerminalCode());
            }
            contactList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getContacts(), TerminalContactDto.class, TerminalContact.class, HashSet.class, ArrayList.class, new String[0]);
            contactList.forEach(a -> a.setTerminalCode(dto.getTerminalCode()));
            contactList.forEach(a -> a.setTenantCode(TenantUtils.getTenantCode()));
        }
        this.terminalContactService.saveBatch(contactList, dto.getTerminalCode());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getSupplys())) {
            for (Object item : dto.getSupplys()) {
                item.setTerminalCode(dto.getTerminalCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        this.terminalSupplyVoService.saveBatch(dto.getSupplys(), dto.getTerminalCode());
        List personVos = dto.getPersonVos();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)personVos)) {
            for (TerminalPersonVo item : personVos) {
                item.setTerminalId(dto.getTerminalId());
                item.setSourcesId(dto.getSourcesId());
                item.setTerminalName(dto.getTerminalName());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        this.personVoService.saveBatch(personVos, dto.getTerminalId());
        List relationshipList = dto.getRelationshipList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relationshipList)) {
            for (SupplyRelationshipDto item : relationshipList) {
                item.setBuyerId(dto.getId());
                item.setBuyerSourceId(dto.getSourcesId());
                item.setBuyerCode(dto.getTerminalCode());
                item.setBuyerName(dto.getTerminalName());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setBuyerType(BuyerTypeEnum.TERMINAL.getCode());
                item.setBuyerSmallType(dto.getChannel());
                item.setBuyerClassify(dto.getTerminalClassifyId());
                item.setTenantCode(TenantUtils.getTenantCode());
            }
            this.supplyRelationshipSdkService.savaOrUpdate(relationshipList, dto.getId());
        }
    }

    private TerminalVo buildByDtoAndTerminal(TerminalDto dto, Terminal terminal) {
        TerminalVo vo = (TerminalVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminal, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getOrgList())) {
            vo.setOrgList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getOrgList(), TerminalRelaOrgDto.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getCustomerOrgList())) {
            vo.setCustomerOrgList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerOrgList(), TerminalRelaCustomerOrgDto.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getContacts())) {
            vo.setContacts((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getContacts(), TerminalContactDto.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getSupplys())) {
            vo.setSupplys((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getSupplys(), TerminalSupplyDto.class, TerminalSupplyVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }

    private List<TerminalVo> buildTerminalVoList(List<Terminal> terminalList, List<TerminalRelaOrg> terminalRelaOrgList, List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgList, List<TerminalContact> terminalContactList, List<TerminalSupplyVo> terminalSupplyVoList, List<TerminalTag> terminalTags, List<TerminalPersonEntity> terminalPersonList) {
        List list;
        List<TerminalVo> re = Lists.newLinkedList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<Object, Object> mapOrg = Maps.newHashMap();
        Map<Object, Object> mapCustomerOrg = Maps.newHashMap();
        Map<Object, Object> mapContact = Maps.newHashMap();
        Map<Object, Object> mapSupply = Maps.newHashMap();
        Map<Object, Object> tagVos = Maps.newHashMap();
        Map<Object, Object> personMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalRelaOrgList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaOrgList, TerminalRelaOrg.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapOrg = list.stream().collect(Collectors.groupingBy(TerminalRelaOrgVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalRelaCustomerOrgList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaCustomerOrgList, TerminalRelaCustomerOrg.class, TerminalRelaCustomerOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapCustomerOrg = list.stream().collect(Collectors.groupingBy(TerminalRelaCustomerOrgVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalContactList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalContactList, TerminalContact.class, TerminalContactVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapContact = list.stream().collect(Collectors.groupingBy(TerminalContactVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalTags)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalTags, TerminalTag.class, TerminalTagVo.class, HashSet.class, ArrayList.class, new String[0]);
            tagVos = list.stream().collect(Collectors.groupingBy(TerminalTagVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalSupplyVoList)) {
            mapSupply = terminalSupplyVoList.stream().collect(Collectors.groupingBy(TerminalSupplyVo::getTerminalCode));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalPersonList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalPersonList, TerminalPersonEntity.class, TerminalPersonVo.class, HashSet.class, ArrayList.class, new String[0]);
            personMap = list.stream().collect(Collectors.groupingBy(TerminalPersonVo::getTerminalId));
        }
        for (TerminalVo vo : re) {
            vo.setOrgList((List)mapOrg.get(vo.getTerminalCode()));
            vo.setCustomerOrgList((List)mapCustomerOrg.get(vo.getTerminalCode()));
            vo.setContacts((List)mapContact.get(vo.getTerminalCode()));
            vo.setSupplys((List)mapSupply.get(vo.getTerminalCode()));
            vo.setTagVos((List)tagVos.get(vo.getTerminalCode()));
            vo.setPersonVos((List)personMap.get(vo.getTerminalId()));
        }
        return re;
    }

    private void validateContacts(TerminalDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List contacts = dto.getContacts();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)contacts)) {
            return;
        }
        for (TerminalContactDto contact : contacts) {
            if (!StringUtils.isNotBlank((CharSequence)contact.getContactName()) && !StringUtils.isNotBlank((CharSequence)contact.getContactPhone()) && Objects.isNull(contact.getContactMain())) continue;
            Validate.notBlank((CharSequence)contact.getContactPhone(), (String)"\u7f3a\u5931\u8054\u7cfb\u7535\u8bdd", (Object[])new Object[0]);
            Validate.notNull((Object)contact.getContactMain(), (String)"\u8bf7\u9009\u62e9\u662f\u5426\u662f\u4e3b\u8054\u7cfb\u4eba", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)contact.getContactName(), (String)"\u7f3a\u5931\u59d3\u540d", (Object[])new Object[0]);
        }
        List contanctsByMain = contacts.stream().filter(o -> Boolean.TRUE.equals(o.getContactMain())).collect(Collectors.toList());
        Validate.isTrue((contanctsByMain.size() == 1 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u4e3b\u8054\u7cfb\u4eba", (Object[])new Object[0]);
    }

    private List<TerminalVo> convertEntityToVo(List<Terminal> terminalList) {
        Set customerOrgCodeSet;
        List<Object> re = Lists.newArrayList();
        List<String> terminalCodeList = terminalList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        List<String> terminalIdList = terminalList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalId())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return re;
        }
        List<TerminalRelaOrg> terminalRelaOrgList = this.terminalRelaOrgService.findByTerminalCodes(terminalCodeList);
        List<TerminalRelaCustomerOrg> terminalRelaCustomerOrgList = this.terminalRelaCustomerOrgService.findByTerminalCodes(terminalCodeList);
        Set orgCodeSet = terminalRelaOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrg::getOrgCode).collect(Collectors.toSet());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orgCodeSet)) {
            List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodeSet));
            orgVoList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgVoList) ? Lists.newLinkedList() : orgVoList;
            Map<String, String> map = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getOrgName()})).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
            terminalRelaOrgList.forEach(a -> a.setOrgName((String)map.get(a.getOrgCode())));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerOrgCodeSet = terminalRelaCustomerOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaCustomerOrg::getOrgCode).collect(Collectors.toSet()))) {
            List customerOrgVoList = this.customerOrgVoSdkService.findListByCodes((List)Lists.newArrayList(customerOrgCodeSet));
            customerOrgVoList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerOrgVoList) ? Lists.newLinkedList() : customerOrgVoList;
            Map<String, String> map = customerOrgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerOrgCode(), a.getCustomerOrgName()})).collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, CustomerOrgVo::getCustomerOrgName, (a, b) -> a));
            terminalRelaCustomerOrgList.forEach(a -> a.setOrgName((String)map.get(a.getOrgCode())));
        }
        List<TerminalPersonEntity> terminalPersonList = this.personVoService.findTerminalPerson(terminalIdList);
        List<TerminalContact> terminalContactList = this.terminalContactService.findByTerminalCodes(terminalCodeList);
        List terminalSupplyVoList = this.terminalSupplyVoService.findByTerminalCodes(terminalCodeList);
        List<TerminalTag> terminalTags = this.terminalTagService.findByTerminalCodes(new HashSet<String>(terminalCodeList));
        re = this.buildTerminalVoList(terminalList, terminalRelaOrgList, terminalRelaCustomerOrgList, terminalContactList, terminalSupplyVoList, terminalTags, terminalPersonList);
        return re;
    }

    private String commitProcess(TerminalDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        String processKey = processBusiness.getProcessKey();
        if (StringUtils.isBlank((CharSequence)processKey)) {
            processBusiness.setProcessKey(this.defaultProcessKey);
        } else {
            processBusiness.setProcessKey(processKey);
        }
        processBusiness.setProcessTitle(TERMINAL_PROCESS_NAME);
        processBusiness.setBusinessNo(dto.getTerminalCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("terminal_create");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        return processBusinessVo.getProcessNo();
    }

    public List<TerminalVo> findByLngAndLat(TerminalLugAndLatQueryDto dto) {
        Validate.notNull((Object)dto, (String)"\u67e5\u8be2\u7ec8\u7aef\u65f6\uff0c\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCurrentLng(), (String)"\u67e5\u8be2\u7ec8\u7aef\u65f6\uff0c\u5f53\u524d\u7ecf\u5ea6\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCurrentLat(), (String)"\u67e5\u8be2\u7ec8\u7aef\u65f6\uff0c\u5f53\u524d\u7eac\u5ea6\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDistance(), (String)"\u67e5\u8be2\u7ec8\u7aef\u65f6\uff0c\u67e5\u8be2\u8ddd\u79bb\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCityCode(), (String)"\u67e5\u8be2\u7ec8\u7aef\u65f6\uff0c\u5f53\u524d\u57ce\u5e02\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        double DISTANCE = Double.parseDouble(dto.getDistance());
        double lng = Double.parseDouble(dto.getCurrentLng());
        double lat = Double.parseDouble(dto.getCurrentLat());
        Map<String, Double> map = this.findNeighDrugstore(lng, lat, DISTANCE);
        Double minLat = map.get("minlat");
        Double maxLat = map.get("maxlat");
        Double minLng = map.get("minlng");
        Double maxLng = map.get("maxlng");
        dto.setMinLat(minLat);
        dto.setMaxLat(maxLat);
        dto.setMinLng(minLng);
        dto.setMaxLng(maxLng);
        List<Object> terminalVos = Lists.newArrayList();
        List<Terminal> terminals = this.terminalService.findByLngAndLat(dto, TenantUtils.getTenantCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminals)) {
            return terminalVos;
        }
        List terminalList = terminals.stream().filter(terminal -> DistanceUtil.calculatePointDistance((double)lat, (double)lng, (double)terminal.getLatitude().doubleValue(), (double)terminal.getLongitude().doubleValue()) <= DISTANCE * 1000.0).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalList)) {
            return terminalVos;
        }
        terminalVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        terminalVos.stream().forEach(terminalVo -> {
            double distance = DistanceUtil.calculatePointDistance((double)lat, (double)lng, (double)terminalVo.getLatitude().doubleValue(), (double)terminalVo.getLongitude().doubleValue());
            terminalVo.setDistanceBetween(Long.valueOf(Math.round(distance)));
        });
        terminalVos = terminalVos.stream().sorted(Comparator.comparing(TerminalVo::getDistanceBetween)).collect(Collectors.toList());
        return terminalVos;
    }

    public Page<TerminalVo> findNearbyTerminals(Pageable pageable, NearbyTerminalsDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (Objects.isNull(dto)) {
            return page;
        }
        Page<TerminalVo> resultPage = this.terminalRepository.findNearbyTerminals(page, dto);
        List records = resultPage.getRecords();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)records)) {
            List<String> ids = records.stream().map(o -> o.getId()).collect(Collectors.toList());
            List<TerminalAddressEntity> addressEntities = this.addressRepository.findByTerminalIds(ids);
            Map addressEntityMap = addressEntities.stream().collect(Collectors.toMap(TerminalAddressEntity::getTerminalId, Function.identity(), (v1, v2) -> v2));
            for (TerminalVo terminalVo : records) {
                TerminalAddressEntity entity = (TerminalAddressEntity)((Object)addressEntityMap.get(terminalVo.getId()));
                if (!Objects.nonNull((Object)entity)) continue;
                terminalVo.setTerminalAddress(entity.getAddressDetail());
            }
        }
        return resultPage;
    }

    public List<TerminalVo> findTerminalList(TerminalNewSearchDto dto) {
        LinkedList list = Lists.newLinkedList();
        List ids = dto.getIds();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ids)) {
            return list;
        }
        List terminalVoList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.terminalRepository.lambdaQuery().in(UuidEntity::getId, (Collection)ids)).in(UuidFlagOpEntity::getEnableStatus, new Object[]{EnableStatusEnum.ENABLE.getCode()})).in(TenantFlagOpEntity::getTenantCode, new Object[]{TenantUtils.getTenantCode()})).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)terminalVoList)) {
            return list;
        }
        return this.convertEntityToVo(terminalVoList, dto);
    }

    private Map<String, Double> findNeighDrugstore(double longitude, double latitude, double distance) {
        double minlat = 0.0;
        double maxlat = 0.0;
        double minlng = 0.0;
        double maxlng = 0.0;
        double r = 6371.0;
        double dis = distance;
        double dlng = 2.0 * Math.asin(Math.sin(dis / (2.0 * r)) / Math.cos(longitude * Math.PI / 180.0));
        dlng = dlng * 180.0 / Math.PI;
        double dlat = dis / r;
        dlat = dlat * 180.0 / Math.PI;
        if (dlng < 0.0) {
            minlng = longitude + dlng;
            maxlng = longitude - dlng;
        } else {
            minlng = longitude - dlng;
            maxlng = longitude + dlng;
        }
        if (dlat < 0.0) {
            minlat = latitude + dlat;
            maxlat = latitude - dlat;
        } else {
            minlat = latitude - dlat;
            maxlat = latitude + dlat;
        }
        HashMap<String, Double> params = new HashMap<String, Double>();
        params.put("minlat", minlat);
        params.put("maxlat", maxlat);
        params.put("minlng", minlng);
        params.put("maxlng", maxlng);
        return params;
    }

    private List<TerminalVo> convertEntityToVo(List<Terminal> terminalList, TerminalNewSearchDto dto) {
        List<TerminalPersonEntity> terminalPerson;
        List<TerminalAddressEntity> addressEntityList;
        List supplyVos;
        Map<String, List<TerminalRelaOrgVo>> map;
        List<TerminalRelaOrg> terminalRelaOrgs;
        Set extendSet = dto.getExtendSet();
        ArrayList re = Lists.newArrayList();
        List result = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, Terminal.class, TerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<String> terminalCodeList = terminalList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        List terminalIdList = terminalList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalId())).map(Terminal::getTerminalCode).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(terminalCodeList)) {
            return re;
        }
        if (extendSet.contains(TerminalVoExtendEnum.ORG.getCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalRelaOrgs = this.terminalRelaOrgRepository.findByTerminalCodes(terminalCodeList))) {
            List terminalRelaOrgVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalRelaOrgs, TerminalRelaOrg.class, TerminalRelaOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            map = terminalRelaOrgVoList.stream().collect(Collectors.groupingBy(TerminalRelaOrgVo::getTerminalId));
            result.forEach(o -> o.setOrgList((List)map.get(o.getTerminalId())));
        }
        if (extendSet.contains(TerminalVoExtendEnum.SUPPLY.getCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(supplyVos = this.terminalSupplyVoService.findByTerminalCodes(terminalCodeList)))) {
            result.forEach(o -> o.setSupplys(supplyVos));
        }
        if (extendSet.contains(TerminalVoExtendEnum.ADDRESS.getCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(addressEntityList = this.addressRepository.findByTerminalCode(terminalCodeList))) {
            Map map2 = addressEntityList.stream().collect(HashMap::new, (k, v) -> k.put(v.getTerminalId(), v.getAddressDetail()), HashMap::putAll);
            result.forEach(o -> o.setTerminalAddress((String)map2.get(o.getTerminalId())));
        }
        if (extendSet.contains(TerminalVoExtendEnum.PERSON.getCode()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(terminalPerson = this.personVoService.findTerminalPersonByCode(terminalCodeList))) {
            List personVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalPerson, TerminalPersonEntity.class, TerminalPersonVo.class, HashSet.class, ArrayList.class, new String[0]);
            map = personVos.stream().collect(Collectors.groupingBy(TerminalPersonVo::getTerminalId));
            result.forEach(o -> o.setPersonVos((List)map.get(o.getTerminalId())));
        }
        return result;
    }
}

