/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.biz.crm.mdm.business.org.sdk.event.OrgEventListener;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalRelaOrg;
import com.biz.crm.mdm.business.terminal.local.service.TerminalRelaOrgService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrgEventListenerImpl
implements OrgEventListener {
    @Autowired(required=false)
    private TerminalRelaOrgService terminalRelaOrgService;

    public void onDelete(List<String> orgCodes) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(orgCodes), (String)"\u7ec4\u7ec7\u7f16\u7801\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<TerminalRelaOrg> list = this.terminalRelaOrgService.findByOrgCodes(orgCodes);
        Set orgCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrg::getOrgCode).collect(Collectors.toSet());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(orgCodeSet), (String)(StringUtils.join(orgCodeSet, (String)",") + "\u5b58\u5728\u5df2\u5173\u8054\u7ec8\u7aef\u7684\u7ec4\u7ec7,\u4e0d\u80fd\u5220\u9664!"), (Object[])new Object[0]);
    }

    public void onDeleteBatch(OrgEventBatchDto orgEventBatchDto) {
    }

    public void onEnableBatch(OrgEventBatchDto orgEventBatchDto) {
    }

    public void onDisableBatch(OrgEventBatchDto orgEventBatchDto) {
    }

    public void onUpdate(OrgEventDto orgEventDto) {
    }
}

