/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.local.service.notifier;

import com.biz.crm.mdm.business.customer.sdk.dto.CustomerEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mdm.business.terminal.local.entity.Terminal;
import com.biz.crm.mdm.business.terminal.local.entity.TerminalSupply;
import com.biz.crm.mdm.business.terminal.local.service.TerminalService;
import com.biz.crm.mdm.business.terminal.local.service.TerminalSupplyService;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalCustomerEventListenerImpl
implements CustomerEventListener {
    @Autowired(required=false)
    private TerminalSupplyService terminalSupplyService;
    @Autowired(required=false)
    private TerminalService terminalService;

    public void onDelete(CustomerEventDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOriginal(), (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<TerminalSupply> supplyList = this.terminalSupplyService.findByCustomerCodes(Sets.newHashSet((Object[])new String[]{dto.getOriginal().getCustomerCode()}));
        if (CollectionUtils.isEmpty(supplyList)) {
            return;
        }
        List<String> terminalCodes = supplyList.stream().map(TerminalSupply::getTerminalCode).collect(Collectors.toList());
        List<Terminal> terminalList = this.terminalService.findByTerminalCodes(terminalCodes);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(terminalList), (String)"\u8be5\u5ba2\u6237\u4e0e\u7ec8\u7aef\u5b58\u5728\u4f9b\u8d27\u5173\u7cfb\u4fe1\u606f\uff0c\u65e0\u6cd5\u5220\u9664!", (Object[])new Object[0]);
    }
}

