package com.biz.crm.mdm.business.terminal.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;

/**
 * 组合条件查询对应的终端编码dto
 *
 * @author sunx
 * @date 2022/2/24
 */
@Data
@ApiModel(value = "TerminalCodeSearchDto", description = "组合条件查询对应的终端编码dto")
public class TerminalCodeSearchDto {
  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private Set<String> orgCodeSet;
  /** 渠道编码集合 */
  @ApiModelProperty("渠道编码集合")
  private Set<String> channelSet;
  /** 标签集合 */
  @ApiModelProperty("标签集合")
  private Set<String> tagSet;
  /** 数据状态（删除状态） */
  @ApiModelProperty("删除状态")
  private String delFlag;
  /** 数据业务状态（启用状态） */
  @ApiModelProperty("启用状态")
  private String enableStatus;
  /** 审批状态 */
  @ApiModelProperty("审批状态,枚举TerminalActApproveStatusEnum")
  private String actApproveStatus;
}
