package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端信息分页查询dto
 *
 * @author sunx
 * @since 2021-10-19 13:53:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalPaginationDto", description = "终端信息分页查询dto")
public class TerminalPaginationDto extends TenantFlagOpDto {
  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /** 客户组织编码 */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;
  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;
  /** 终端名称 */
  @ApiModelProperty("终端名称")
  private String terminalName;
  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;
  /** 编码名称模糊查询 */
  @ApiModelProperty("编码名称模糊查询")
  private String keyword;
  /** 不包含门店编码查询条件 * */
  @ApiModelProperty("不包含门店编码查询条件")
  private List<String> notIncludeTerminalCodeList;
  /** 不包含门店编码查询条件 * */
  @ApiModelProperty("标签名称")
  private String tagName;
  /** 渠道 * */
  @ApiModelProperty("渠道")
  private String channel;
  /** 组织编码集合 */
  @ApiModelProperty("组织编码集合")
  private String orgCodeList;
  /** 营业注册号 */
  @ApiModelProperty("营业注册号")
  private String licenseRegisterNumber;
  /** 终端地址 */
  @ApiModelProperty("终端地址")
  private String terminalAddress;
  /** 审批状态 */
  @ApiModelProperty("审批状态")
  private String processStatus;
  /**回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据*/
  @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
  private List<String> selectedCode;
}
